/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DetachedDropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DragAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.PartDragAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.SplitDropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.StackDropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

class DnDManager {
    private static final Rectangle offScreenRect = new Rectangle(10000, -10000, 1, 1);
    public static final int HOSTED = 1;
    public static final int GHOSTED = 2;
    public static final int SIMPLE = 3;
    private int feedbackStyle = 3;
    Collection<DragAgent> dragAgents = new ArrayList<DragAgent>();
    Collection<DropAgent> dropAgents = new ArrayList<DropAgent>();
    DnDInfo info;
    DragAgent dragAgent;
    DropAgent dropAgent;
    private MWindow dragWindow;
    private Shell dragHost;
    private Control dragCtrl;
    private Tracker tracker;
    private Shell overlayFrame;
    private List<Rectangle> frames = new ArrayList<Rectangle>();
    private List<Image> images = new ArrayList<Image>();
    private List<Rectangle> imageRects = new ArrayList<Rectangle>();

    public void addFrame(Rectangle newRect) {
        this.frames.add(newRect);
        this.updateOverlay();
    }

    public void addImage(Rectangle imageRect, Image image) {
        this.imageRects.add(imageRect);
        this.images.add(image);
        this.updateOverlay();
    }

    public DnDManager(MWindow topLevelWindow) {
        this.dragWindow = topLevelWindow;
        this.info = new DnDInfo(topLevelWindow);
        this.dragAgents.add(new PartDragAgent(this));
        this.dropAgents.add(new StackDropAgent(this));
        this.dropAgents.add(new SplitDropAgent(this));
        this.dropAgents.add(new DetachedDropAgent(this));
        IEventBroker eventBroker = (IEventBroker)topLevelWindow.getContext().get(IEventBroker.class);
        EventHandler stackWidgetHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (!(element instanceof MPartStack) || !(element.getWidget() instanceof CTabFolder)) {
                    return;
                }
                CTabFolder ctf = (CTabFolder)element.getWidget();
                ctf.addDragDetectListener(new DragDetectListener(){

                    public void dragDetected(DragDetectEvent e) {
                        DnDManager.this.startDrag(e);
                    }
                });
            }
        };
        eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), stackWidgetHandler);
        this.getDragShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DnDManager.this.dispose();
            }
        });
    }

    public MWindow getDragWindow() {
        return this.dragWindow;
    }

    public EModelService getModelService() {
        return (EModelService)this.dragWindow.getContext().get(EModelService.class);
    }

    public Shell getDragShell() {
        return (Shell)(this.dragWindow.getWidget() instanceof Shell ? this.dragWindow.getWidget() : null);
    }

    protected void dispose() {
        this.clearOverlay();
        if (this.overlayFrame != null && !this.overlayFrame.isDisposed()) {
            this.overlayFrame.dispose();
        }
        this.overlayFrame = null;
    }

    protected void startDrag(DragDetectEvent e) {
        this.info.update(e);
        this.dragAgent = this.getDragAgent(this.info);
        if (this.dragAgent == null) {
            return;
        }
        this.tracker = new Tracker(Display.getCurrent(), 0);
        this.tracker.setStippled(true);
        this.tracker.addListener(10, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                Display.getCurrent().syncExec(new Runnable(){

                    public void run() {
                        (this).DnDManager.this.info.update();
                        DropAgent curAgent = (this).DnDManager.this.dropAgent;
                        if ((this).DnDManager.this.dropAgent != null) {
                            DropAgent dropAgent = (this).DnDManager.this.dropAgent = (this).DnDManager.this.dropAgent.track((this).DnDManager.this.dragAgent.dragElement, (this).DnDManager.this.info) ? (this).DnDManager.this.dropAgent : null;
                        }
                        if ((this).DnDManager.this.dropAgent == null) {
                            if (curAgent != null) {
                                curAgent.dragLeave((this).DnDManager.this.dragAgent.dragElement, (this).DnDManager.this.info);
                            }
                            (this).DnDManager.this.dropAgent = DnDManager.this.getDropAgent((this).DnDManager.this.dragAgent.dragElement, (this).DnDManager.this.info);
                            if ((this).DnDManager.this.dropAgent != null) {
                                (this).DnDManager.this.dropAgent.dragEnter((this).DnDManager.this.dragAgent.dragElement, (this).DnDManager.this.info);
                            } else {
                                DnDManager.this.setCursor(Display.getCurrent().getSystemCursor(20));
                                DnDManager.this.setRectangle(offScreenRect);
                            }
                        }
                        DnDManager.this.update();
                    }
                });
            }
        });
        this.getDragShell().setCapture(true);
        try {
            this.dragAgent.dragStart(this.dragAgent.dragElement, this.info);
            this.dropAgent = this.getDropAgent(this.dragAgent.dragElement, this.info);
            boolean performDrop = this.tracker.open();
            this.finishDrag(performDrop);
        }
        finally {
            this.getDragShell().setCursor(null);
            this.getDragShell().setCapture(false);
        }
    }

    public void update() {
        while (Display.getCurrent().readAndDispatch()) {
        }
        Display.getCurrent().update();
    }

    private void finishDrag(boolean performDrop) {
        try {
            boolean isNoDrop;
            boolean bl = isNoDrop = this.getDragShell().getCursor() == Display.getCurrent().getSystemCursor(20);
            if (performDrop && this.dropAgent != null && !isNoDrop) {
                this.dropAgent.drop(this.dragAgent.dragElement, this.info);
            } else {
                this.dragAgent.cancelDrag();
            }
            this.dragAgent.dragFinished();
        }
        finally {
            if (this.tracker != null && !this.tracker.isDisposed()) {
                this.tracker.dispose();
                this.tracker = null;
            }
            if (this.overlayFrame != null) {
                this.overlayFrame.dispose();
                this.overlayFrame = null;
            }
            if (this.dragHost != null) {
                this.dragHost.dispose();
                this.dragHost = null;
            }
            this.dragAgent = null;
            this.dropAgent = null;
        }
    }

    public void setCursor(Cursor newCursor) {
        this.getDragShell().setCursor(newCursor);
    }

    public void setRectangle(Rectangle newRect) {
        if (this.tracker == null) {
            return;
        }
        Rectangle[] rectArray = new Rectangle[]{newRect};
        this.tracker.setRectangles(rectArray);
    }

    public void hostElement(MUIElement element, int xOffset, int yOffset) {
        if (element == null) {
            if (this.dragHost != null && !this.dragHost.isDisposed()) {
                this.dragHost.dispose();
            }
            this.dragHost = null;
            return;
        }
        Shell parentShell = this.getDragShell();
        this.dragHost = new Shell(parentShell, 8);
        this.dragHost.setBackground(parentShell.getDisplay().getSystemColor(1));
        this.dragHost.setLayout((Layout)new FillLayout());
        this.dragHost.setAlpha(120);
        Region shellRgn = new Region((Device)this.dragHost.getDisplay());
        this.dragHost.setRegion(shellRgn);
        this.dragCtrl = (Control)element.getWidget();
        if (this.dragCtrl != null) {
            this.dragHost.setSize(this.dragCtrl.getSize());
        } else {
            this.dragHost.setSize(400, 400);
        }
        if (this.feedbackStyle == 1) {
            MElementContainer elementParent = element.getParent();
            if (elementParent instanceof MPartStack && elementParent.getWidget() instanceof CTabFolder) {
                CTabFolder curCTF = (CTabFolder)elementParent.getWidget();
                this.dragHost.setSize(curCTF.getSize());
                CTabItem elementItem = this.getItemForElement(curCTF, element);
                assert (elementItem != null);
                IPresentationEngine renderingEngine = (IPresentationEngine)this.dragWindow.getContext().get(IPresentationEngine.class);
                CTabFolder ctf = new CTabFolder((Composite)this.dragHost, 2048);
                CTabItem newItem = new CTabItem(ctf, 0);
                newItem.setText(elementItem.getText());
                newItem.setImage(elementItem.getImage());
                element.getParent().getChildren().remove(element);
                this.dragCtrl = (Control)renderingEngine.createGui(element, (Object)ctf, this.getModelService().getContainingContext(element));
                newItem.setControl(this.dragCtrl);
            }
        } else if (this.feedbackStyle == 2) {
            this.dragCtrl.setParent((Composite)this.dragHost);
            this.dragCtrl.setLocation(0, 0);
            this.dragHost.layout();
        }
        this.update();
        this.dragHost.open();
        this.info.setDragHost(this.dragHost, xOffset, yOffset);
    }

    public void setDragHostVisibility(boolean visible) {
        if (this.dragHost == null || this.dragHost.isDisposed()) {
            return;
        }
        if (visible) {
            if (this.dragHost.getChildren().length > 0 && this.dragHost.getChildren()[0] instanceof CTabFolder) {
                CTabFolder ctf = (CTabFolder)this.dragHost.getChildren()[0];
                this.dragCtrl.setParent((Composite)ctf);
                this.dragHost.setVisible(true);
            } else {
                this.dragCtrl.setParent((Composite)this.dragHost);
            }
        } else {
            this.dragHost.setVisible(false);
        }
    }

    private CTabItem getItemForElement(CTabFolder elementCTF, MUIElement element) {
        CTabItem[] cTabItemArray = elementCTF.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData("modelElement") == element) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public void clearOverlay() {
        this.frames.clear();
        this.images.clear();
        this.imageRects.clear();
        if (this.overlayFrame != null) {
            this.overlayFrame.setVisible(false);
        }
    }

    private void updateOverlay() {
        Rectangle bounds = this.getOverlayBounds();
        if (bounds == null) {
            this.clearOverlay();
            return;
        }
        if (this.overlayFrame == null) {
            this.overlayFrame = new Shell(this.getDragShell(), 8);
            this.overlayFrame.setBackground(Display.getCurrent().getSystemColor(6));
            this.overlayFrame.setAlpha(150);
            this.overlayFrame.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    int i = 0;
                    while (i < DnDManager.this.images.size()) {
                        Image image = (Image)DnDManager.this.images.get(i);
                        Rectangle iRect = (Rectangle)DnDManager.this.imageRects.get(i);
                        e.gc.drawImage(image, iRect.x, iRect.y);
                        ++i;
                    }
                }
            });
        }
        this.overlayFrame.setBounds(bounds);
        Region curRegion = this.overlayFrame.getRegion();
        if (curRegion != null && !curRegion.isDisposed()) {
            curRegion.dispose();
        }
        Region rgn = new Region();
        for (Rectangle frameRect : this.frames) {
            int x = frameRect.x - bounds.x;
            int y = frameRect.y - bounds.y;
            if (frameRect.width > 6) {
                Rectangle outerBounds = new Rectangle(x - 3, y - 3, frameRect.width + 6, frameRect.height + 6);
                rgn.add(outerBounds);
                Rectangle innerBounds = new Rectangle(x, y, frameRect.width, frameRect.height);
                rgn.subtract(innerBounds);
                continue;
            }
            Rectangle itemBounds = new Rectangle(x, y, frameRect.width, frameRect.height);
            rgn.add(itemBounds);
        }
        int i = 0;
        while (i < this.images.size()) {
            Rectangle ir = this.imageRects.get(i);
            Image im = this.images.get(i);
            int x = ir.x - bounds.x;
            int y = ir.y - bounds.y;
            rgn.add(x, y, im.getBounds().width, im.getBounds().height);
            ++i;
        }
        this.overlayFrame.setRegion(rgn);
        this.overlayFrame.setVisible(true);
    }

    private Rectangle getOverlayBounds() {
        Rectangle bounds = null;
        for (Rectangle fr : this.frames) {
            if (fr.width > 6) {
                Rectangle outerBounds = new Rectangle(fr.x - 3, fr.y - 3, fr.width + 6, fr.height + 6);
                if (bounds == null) {
                    bounds = outerBounds;
                }
                bounds.add(outerBounds);
                continue;
            }
            if (bounds == null) {
                bounds = fr;
            }
            bounds.add(fr);
        }
        for (Rectangle ir : this.imageRects) {
            if (bounds == null) {
                bounds = ir;
            }
            bounds.add(ir);
        }
        return bounds;
    }

    public void frameRect(Rectangle bounds) {
        this.clearOverlay();
        if (bounds != null) {
            this.addFrame(bounds);
        }
    }

    public void addDragAgent(DragAgent newAgent) {
        if (!this.dragAgents.contains(newAgent)) {
            this.dragAgents.add(newAgent);
        }
    }

    public void removeDragAgent(DragAgent agentToRemove) {
        this.dragAgents.remove(agentToRemove);
    }

    public void addDropAgent(DropAgent newAgent) {
        if (!this.dropAgents.contains(newAgent)) {
            this.dropAgents.add(newAgent);
        }
    }

    public void removeDropAgent(DropAgent agentToRemove) {
        this.dropAgents.remove(agentToRemove);
    }

    private DragAgent getDragAgent(DnDInfo info) {
        for (DragAgent agent : this.dragAgents) {
            if (!agent.canDrag(info)) continue;
            return agent;
        }
        return null;
    }

    private DropAgent getDropAgent(MUIElement dragElement, DnDInfo info) {
        for (DropAgent agent : this.dropAgents) {
            if (!agent.canDrop(dragElement, info)) continue;
            return agent;
        }
        return null;
    }

    public int getFeedbackStyle() {
        return this.feedbackStyle;
    }

    public void setHostBounds(Rectangle newBounds) {
        if (this.dragHost == null || this.dragHost.isDisposed()) {
            return;
        }
        this.info.setDragHostBounds(newBounds);
        this.update();
    }
}

