/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.util.Version;

public final class ArabicAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private Set stoptable = new HashSet();
    public static final String STOPWORDS_COMMENT = "#";
    private final Version matchVersion;

    public ArabicAnalyzer() {
        this(Version.LUCENE_24);
    }

    public ArabicAnalyzer(Version matchVersion) {
        this.matchVersion = matchVersion;
        try {
            InputStream stream = ArabicAnalyzer.class.getResourceAsStream(DEFAULT_STOPWORD_FILE);
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            this.stoptable = WordlistLoader.getWordSet((Reader)reader, (String)STOPWORDS_COMMENT);
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ArabicAnalyzer(String[] stopwords) {
        this(Version.LUCENE_24, stopwords);
    }

    public ArabicAnalyzer(Version matchVersion, String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet((String[])stopwords);
        this.matchVersion = matchVersion;
    }

    public ArabicAnalyzer(Hashtable stopwords) {
        this(Version.LUCENE_24, stopwords);
    }

    public ArabicAnalyzer(Version matchVersion, Hashtable stopwords) {
        this.stoptable = new HashSet(stopwords.keySet());
        this.matchVersion = matchVersion;
    }

    public ArabicAnalyzer(File stopwords) throws IOException {
        this(Version.LUCENE_24, stopwords);
    }

    public ArabicAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this.stoptable = WordlistLoader.getWordSet((File)stopwords, (String)STOPWORDS_COMMENT);
        this.matchVersion = matchVersion;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new ArabicLetterTokenizer(reader);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stoptable);
        result = new ArabicNormalizationFilter((TokenStream)result);
        result = new ArabicStemFilter((TokenStream)result);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ArabicLetterTokenizer(reader);
            streams.result = new LowerCaseFilter((TokenStream)streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stoptable);
            streams.result = new ArabicNormalizationFilter(streams.result);
            streams.result = new ArabicStemFilter(streams.result);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

