/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PerspectiveDescriptor
implements IPerspectiveDescriptor,
IPluginContribution {
    private String id;
    private String label;
    private ImageDescriptor image;
    private IConfigurationElement element;

    public PerspectiveDescriptor(String id, String label) {
        this(id, label, null);
    }

    PerspectiveDescriptor(String id, String label, IConfigurationElement element) {
        this.id = id;
        this.label = label;
        this.element = element;
    }

    public IConfigurationElement getConfigElement() {
        return this.element;
    }

    public IPerspectiveFactory createFactory() {
        try {
            return (IPerspectiveFactory)this.element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.element);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.image == null) {
            String icon;
            this.image = WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE");
            if (this.element != null && (icon = this.element.getAttribute("icon")) != null) {
                this.image = AbstractUIPlugin.imageDescriptorFromPlugin(this.element.getNamespaceIdentifier(), icon);
            }
        }
        return this.image;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.element.getNamespaceIdentifier();
    }

    public String getOriginalId() {
        return this.id;
    }
}

