/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.MergeDocIDRemapper;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfos;

class BufferedDeletes {
    int numTerms;
    HashMap terms = new HashMap();
    HashMap queries = new HashMap();
    List docIDs = new ArrayList();
    long bytesUsed;

    BufferedDeletes() {
    }

    int size() {
        return this.numTerms + this.queries.size() + this.docIDs.size();
    }

    void update(BufferedDeletes in) {
        this.numTerms += in.numTerms;
        this.bytesUsed += in.bytesUsed;
        this.terms.putAll(in.terms);
        this.queries.putAll(in.queries);
        this.docIDs.addAll(in.docIDs);
        in.clear();
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numTerms = 0;
        this.bytesUsed = 0L;
    }

    void addBytesUsed(long b) {
        this.bytesUsed += b;
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0;
    }

    synchronized void remap(MergeDocIDRemapper mapper, SegmentInfos infos, int[][] docMaps, int[] delCounts, MergePolicy.OneMerge merge, int mergeDocCount) {
        HashMap newDeleteQueries;
        ArrayList<Integer> newDeleteDocIDs;
        Object num;
        HashMap newDeleteTerms;
        if (this.terms.size() > 0) {
            newDeleteTerms = new HashMap();
            Iterator iter = this.terms.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                num = (Num)entry.getValue();
                newDeleteTerms.put(entry.getKey(), new Num(mapper.remap(((Num)num).getNum())));
            }
        } else {
            newDeleteTerms = null;
        }
        if (this.docIDs.size() > 0) {
            newDeleteDocIDs = new ArrayList<Integer>(this.docIDs.size());
            Iterator iter = this.docIDs.iterator();
            while (iter.hasNext()) {
                num = (Integer)iter.next();
                newDeleteDocIDs.add(new Integer(mapper.remap((Integer)num)));
            }
        } else {
            newDeleteDocIDs = null;
        }
        if (this.queries.size() > 0) {
            newDeleteQueries = new HashMap(this.queries.size());
            Iterator iter = this.queries.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Integer num2 = (Integer)entry.getValue();
                newDeleteQueries.put(entry.getKey(), new Integer(mapper.remap(num2)));
            }
        } else {
            newDeleteQueries = null;
        }
        if (newDeleteTerms != null) {
            this.terms = newDeleteTerms;
        }
        if (newDeleteDocIDs != null) {
            this.docIDs = newDeleteDocIDs;
        }
        if (newDeleteQueries != null) {
            this.queries = newDeleteQueries;
        }
    }

    static final class Num {
        private int num;

        Num(int num) {
            this.num = num;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num) {
            if (num > this.num) {
                this.num = num;
            }
        }
    }
}

