/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableCreationDialog
extends StatusDialog {
    private IDialogSettings fDialogSettings;
    private StringDialogField fNameField;
    private StatusInfo fNameStatus;
    private StringButtonDialogField fPathField;
    private StatusInfo fPathStatus;
    private SelectionButtonDialogField fDirButton;
    private CPVariableElement fElement;
    private List<CPVariableElement> fExistingNames;

    public VariableCreationDialog(Shell parent, CPVariableElement element, List<CPVariableElement> existingNames) {
        super(parent);
        if (element == null) {
            this.setTitle(NewWizardMessages.VariableCreationDialog_titlenew);
        } else {
            this.setTitle(NewWizardMessages.VariableCreationDialog_titleedit);
        }
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fElement = element;
        this.fNameStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        NewVariableAdapter adapter = new NewVariableAdapter();
        this.fNameField = new StringDialogField();
        this.fNameField.setDialogFieldListener(adapter);
        this.fNameField.setLabelText(NewWizardMessages.VariableCreationDialog_name_label);
        this.fPathField = new StringButtonDialogField(adapter);
        this.fPathField.setDialogFieldListener(adapter);
        this.fPathField.setLabelText(NewWizardMessages.VariableCreationDialog_path_label);
        this.fPathField.setButtonLabel(NewWizardMessages.VariableCreationDialog_path_file_button);
        this.fDirButton = new SelectionButtonDialogField(8);
        this.fDirButton.setDialogFieldListener(adapter);
        this.fDirButton.setLabelText(NewWizardMessages.VariableCreationDialog_path_dir_button);
        this.fExistingNames = existingNames;
        if (element != null) {
            this.fNameField.setText(element.getName());
            this.fPathField.setText(element.getPath().toString());
            this.fExistingNames.remove(element.getName());
        } else {
            this.fNameField.setText("");
            this.fPathField.setText("");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.variable_creation_dialog_context");
    }

    public CPVariableElement getClasspathElement() {
        return new CPVariableElement(this.fNameField.getText(), (IPath)new Path(this.fPathField.getText()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 4;
        inner.setLayout((Layout)layout);
        int fieldWidthHint = this.convertWidthInCharsToPixels(50);
        this.fNameField.doFillIntoGrid(inner, 2);
        LayoutUtil.setWidthHint((Control)this.fNameField.getTextControl(null), fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        DialogField.createEmptySpace(inner, 2);
        this.fPathField.doFillIntoGrid(inner, 3);
        LayoutUtil.setWidthHint((Control)this.fPathField.getTextControl(null), fieldWidthHint);
        this.fDirButton.doFillIntoGrid(inner, 1);
        StringDialogField focusField = this.fElement == null ? this.fNameField : this.fPathField;
        focusField.postSetFocusOnDialogField(parent.getDisplay());
        VariableCreationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doChangeControlPressed(DialogField field) {
        IPath path;
        if (field == this.fPathField && (path = this.chooseExtJarFile()) != null) {
            this.fPathField.setText(path.toString());
        }
    }

    private void doFieldUpdated(DialogField field) {
        IPath path;
        if (field == this.fNameField) {
            this.fNameStatus = this.nameUpdated();
        } else if (field == this.fPathField) {
            this.fPathStatus = this.pathUpdated();
        } else if (field == this.fDirButton && (path = this.chooseExtDirectory()) != null) {
            this.fPathField.setText(path.toString());
        }
        this.updateStatus(StatusUtil.getMoreSevere(this.fPathStatus, this.fNameStatus));
    }

    private StatusInfo nameUpdated() {
        StatusInfo status = new StatusInfo();
        String name = this.fNameField.getText();
        if (name.length() == 0) {
            status.setError(NewWizardMessages.VariableCreationDialog_error_entername);
            return status;
        }
        if (name.trim().length() != name.length()) {
            status.setError(NewWizardMessages.VariableCreationDialog_error_whitespace);
        } else if (!Path.ROOT.isValidSegment(name)) {
            status.setError(NewWizardMessages.VariableCreationDialog_error_invalidname);
        } else if (this.nameConflict(name)) {
            status.setError(NewWizardMessages.VariableCreationDialog_error_nameexists);
        }
        return status;
    }

    private boolean nameConflict(String name) {
        if (this.fElement != null && this.fElement.getName().equals(name)) {
            return false;
        }
        int i = 0;
        while (i < this.fExistingNames.size()) {
            CPVariableElement elem = this.fExistingNames.get(i);
            if (name.equals(elem.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private StatusInfo pathUpdated() {
        StatusInfo status = new StatusInfo();
        String path = this.fPathField.getText();
        if (path.length() > 0) {
            if (!Path.ROOT.isValidPath(path)) {
                status.setError(NewWizardMessages.VariableCreationDialog_error_invalidpath);
            } else if (!new File(path).exists()) {
                status.setWarning(NewWizardMessages.VariableCreationDialog_warning_pathnotexists);
            }
        }
        return status;
    }

    private String getInitPath() {
        String initPath = this.fPathField.getText();
        if (initPath.length() == 0) {
            initPath = this.fDialogSettings.get("org.eclipse.jdt.ui.lastextjar");
            if (initPath == null) {
                initPath = "";
            }
        } else {
            Path entryPath = new Path(initPath);
            if (ArchiveFileFilter.isArchivePath((IPath)entryPath, true)) {
                entryPath.removeLastSegments(1);
            }
            initPath = entryPath.toOSString();
        }
        return initPath;
    }

    private IPath chooseExtJarFile() {
        String initPath = this.getInitPath();
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(NewWizardMessages.VariableCreationDialog_extjardialog_text);
        dialog.setFilterExtensions(ArchiveFileFilter.ALL_ARCHIVES_FILTER_EXTENSIONS);
        dialog.setFilterPath(initPath);
        String res = dialog.open();
        if (res != null) {
            this.fDialogSettings.put("org.eclipse.jdt.ui.lastextjar", dialog.getFilterPath());
            return Path.fromOSString((String)res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtDirectory() {
        String initPath = this.getInitPath();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(NewWizardMessages.VariableCreationDialog_extdirdialog_text);
        dialog.setMessage(NewWizardMessages.VariableCreationDialog_extdirdialog_message);
        dialog.setFilterPath(initPath);
        String res = dialog.open();
        if (res != null) {
            this.fDialogSettings.put("org.eclipse.jdt.ui.lastextjar", dialog.getFilterPath());
            return Path.fromOSString((String)res);
        }
        return null;
    }

    private class NewVariableAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private NewVariableAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            VariableCreationDialog.this.doFieldUpdated(field);
        }

        public void changeControlPressed(DialogField field) {
            VariableCreationDialog.this.doChangeControlPressed(field);
        }
    }
}

