/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeCompletionProposalComputer
extends JavaCompletionProposalComputer {
    @Override
    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        CompletionProposalCollector collector = super.createCollector(context);
        collector.setIgnored(9, false);
        return collector;
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        List<ICompletionProposal> types = super.computeCompletionProposals(context, monitor);
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            try {
                IType expectedType;
                if (types.size() > 0 && context.computeIdentifierPrefix().length() == 0 && (expectedType = javaContext.getExpectedType()) != null) {
                    int relevance = Integer.MAX_VALUE;
                    HashSet<String> proposed = new HashSet<String>();
                    for (AbstractJavaCompletionProposal abstractJavaCompletionProposal : types) {
                        IJavaElement element = abstractJavaCompletionProposal.getJavaElement();
                        if (element instanceof IType) {
                            proposed.add(((IType)element).getFullyQualifiedName());
                        }
                        relevance = Math.min(relevance, abstractJavaCompletionProposal.getRelevance());
                    }
                    List<String> history = JavaPlugin.getDefault().getContentAssistHistory().getHistory(expectedType.getFullyQualifiedName()).getTypes();
                    relevance -= history.size() + 1;
                    for (String type : history) {
                        if (proposed.contains(type)) continue;
                        IJavaCompletionProposal proposal = this.createTypeProposal(relevance, type, javaContext);
                        if (proposal != null) {
                            types.add(proposal);
                        }
                        ++relevance;
                    }
                }
            }
            catch (BadLocationException x) {
                JavaPlugin.log(x);
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x);
            }
        }
        return types;
    }

    private IJavaCompletionProposal createTypeProposal(int relevance, String fullyQualifiedType, JavaContentAssistInvocationContext context) throws JavaModelException {
        IType type = context.getCompilationUnit().getJavaProject().findType(fullyQualifiedType);
        if (type == null) {
            return null;
        }
        CompletionProposal proposal = CompletionProposal.create((int)9, (int)context.getInvocationOffset());
        proposal.setCompletion(fullyQualifiedType.toCharArray());
        proposal.setDeclarationSignature(type.getPackageFragment().getElementName().toCharArray());
        proposal.setFlags(type.getFlags());
        proposal.setRelevance(relevance);
        proposal.setReplaceRange(context.getInvocationOffset(), context.getInvocationOffset());
        proposal.setSignature(Signature.createTypeSignature((String)fullyQualifiedType, (boolean)true).toCharArray());
        if (this.shouldProposeGenerics(context.getProject())) {
            return new LazyGenericTypeProposal(proposal, context);
        }
        return new LazyJavaTypeCompletionProposal(proposal, context);
    }

    protected final boolean shouldProposeGenerics(IJavaProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return sourceVersion != null && "1.5".compareTo(sourceVersion) <= 0;
    }

    @Override
    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        try {
            int angle;
            int pos = contextPosition - 1;
            while ((angle = scanner.findOpeningPeer(pos, bound, '<', '>')) != -1) {
                int end;
                int off;
                String ident;
                int token = scanner.previousToken(angle - 1, bound);
                if (token == 2000 && JavaHeuristicScanner.isGenericStarter(ident = document.get(off = scanner.getPosition() + 1, (end = angle) - off).trim())) {
                    return angle + 1;
                }
                pos = angle - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return super.guessContextInformationPosition(context);
    }
}

