/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.ReconcileEnv;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.core.ICompilationUnit;

public class JavaSourceFilePrintWriter
extends PrintWriter {
    private final StringWriter _sw;
    private final String _typeName;
    private final AbstractCompilationEnv _env;

    public JavaSourceFilePrintWriter(String typeName, StringWriter sw, AbstractCompilationEnv env) throws CoreException {
        super(sw);
        this._sw = sw;
        this._typeName = typeName;
        this._env = env;
        this._env.validateTypeName(typeName);
    }

    public void close() {
        try {
            String contents = this._sw.toString();
            super.close();
            GeneratedFileManager gfm = this._env.getAptProject().getGeneratedFileManager();
            Phase phase = this._env.getPhase();
            FileGenerationResult result = null;
            if (phase == Phase.RECONCILE && this._env.currentProcessorSupportsRTTG()) {
                ReconcileEnv reconcileEnv = (ReconcileEnv)this._env;
                ICompilationUnit parentCompilationUnit = reconcileEnv.getCompilationUnit();
                result = gfm.generateFileDuringReconcile(parentCompilationUnit, this._typeName, contents);
            } else if (phase == Phase.BUILD) {
                result = gfm.generateFileDuringBuild(Collections.singletonList(this._env.getFile()), this._typeName, contents, this._env.currentProcessorSupportsRTTG(), null);
            }
            if (result != null) {
                this._env.addGeneratedSourceFile(result.getFile(), result.isModified());
            }
        }
        catch (CoreException ce) {
            AptPlugin.log(ce, "Unable to generate type when JavaSourceFilePrintWriter was closed");
        }
    }
}

