/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointToggleAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BreakpointSuspendPolicyToggleAction
extends BreakpointToggleAction {
    private int fCurrentPolicy = 2;

    public void doAction(IJavaBreakpoint breakpoint) throws CoreException {
        if (breakpoint.getSuspendPolicy() != this.fCurrentPolicy) {
            breakpoint.setSuspendPolicy(this.fCurrentPolicy);
        }
    }

    protected boolean getToggleState(IJavaBreakpoint breakpoint) {
        return false;
    }

    public boolean isEnabledFor(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IJavaBreakpoint) continue;
            return false;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.isEnabled()) {
            IJavaBreakpoint bp = (IJavaBreakpoint)((IStructuredSelection)selection).getFirstElement();
            this.update(action, bp);
        }
    }

    protected boolean isToggleAction() {
        return false;
    }

    public void update(IAction action, IJavaBreakpoint breakpoint) {
        try {
            if (breakpoint.getSuspendPolicy() == 2) {
                action.setText(ActionMessages.BreakpointSuspendPolicy_Suspend__VM_1);
                this.fCurrentPolicy = 1;
            } else {
                action.setText(ActionMessages.BreakpointSuspendPolicy_Suspend__Thread_2);
                this.fCurrentPolicy = 2;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }
}

