/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IEclipseContextDebugger;
import org.eclipse.e4.core.internal.contexts.debug.ui.AllocationRecorder;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextsView;
import org.eclipse.e4.core.internal.contexts.debug.ui.WeakContextRef;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class ContextTreeProvider
implements IEclipseContextDebugger,
ITreeContentProvider {
    private static final int REFRESH_DELAY = 5000;
    private static Set<WeakReference<EclipseContext>> activeContexts = new HashSet<WeakReference<EclipseContext>>();
    protected static ContextsView view;
    protected static RefreshJob refreshJob;
    private Display display;

    public ContextTreeProvider() {
    }

    public ContextTreeProvider(ContextsView contextView, Display display) {
        view = contextView;
        this.display = display;
        refreshJob = new RefreshJob(display);
    }

    public void setAutoUpdates(boolean update) {
        if (update) {
            if (refreshJob == null && this.display != null) {
                refreshJob = new RefreshJob(this.display);
            }
        } else if (refreshJob != null) {
            refreshJob.cancel();
            refreshJob = null;
        }
    }

    public void dispose() {
        if (refreshJob != null) {
            refreshJob.cancel();
        }
        view = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        Iterator<WeakReference<EclipseContext>> i = activeContexts.iterator();
        while (i.hasNext()) {
            WeakReference<EclipseContext> ref = i.next();
            EclipseContext storedRoot = (EclipseContext)ref.get();
            if (storedRoot != null) continue;
            i.remove();
        }
        return activeContexts.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof WeakReference)) {
            return null;
        }
        WeakReference ref = (WeakReference)parentElement;
        EclipseContext parentContext = (EclipseContext)ref.get();
        if (parentContext == null) {
            return null;
        }
        Set children = parentContext.getChildren();
        if (children == null) {
            return null;
        }
        HashSet<WeakContextRef> childrenRef = new HashSet<WeakContextRef>(children.size());
        for (EclipseContext child : children) {
            childrenRef.add(new WeakContextRef(child));
        }
        return childrenRef.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (!(element instanceof WeakReference)) {
            return false;
        }
        WeakReference ref = (WeakReference)element;
        EclipseContext parentContext = (EclipseContext)ref.get();
        if (parentContext == null) {
            return false;
        }
        return parentContext.getChildren() != null;
    }

    public synchronized void notify(EclipseContext context, IEclipseContextDebugger.EventType type, Object data) {
        switch (type) {
            case CONSTRUCTED: {
                AllocationRecorder.getDefault().allocated(context, new Exception());
                EclipseContext newRoot = this.getRoot((IEclipseContext)context);
                boolean found = false;
                Iterator<WeakReference<EclipseContext>> i = activeContexts.iterator();
                while (i.hasNext()) {
                    WeakReference<EclipseContext> ref = i.next();
                    EclipseContext storedRoot = (EclipseContext)ref.get();
                    if (storedRoot == null) {
                        i.remove();
                        continue;
                    }
                    if (storedRoot != newRoot) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    activeContexts.add(new WeakContextRef(context));
                }
                if (view == null || refreshJob == null) break;
                refreshJob.schedule(5000L);
                break;
            }
            case DISPOSED: {
                Iterator<WeakReference<EclipseContext>> i = activeContexts.iterator();
                while (i.hasNext()) {
                    WeakReference<EclipseContext> ref = i.next();
                    EclipseContext storedRoot = (EclipseContext)ref.get();
                    if (storedRoot == null) {
                        i.remove();
                        continue;
                    }
                    if (storedRoot != context) continue;
                    i.remove();
                    break;
                }
                if (view == null || refreshJob == null) break;
                refreshJob.schedule(5000L);
            }
        }
    }

    private EclipseContext getRoot(IEclipseContext context) {
        IEclipseContext root = context;
        while (context != null) {
            root = context;
            context = context.getParent();
        }
        return (EclipseContext)root;
    }

    private class RefreshJob
    extends UIJob {
        public RefreshJob(Display display) {
            super(display, "Context debug update job");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (view != null) {
                view.refresh();
            }
            return Status.OK_STATUS;
        }
    }
}

