/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.ui.internal.menus.ActionSet;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.menus.EditorAction;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.ViewAction;
import org.eclipse.ui.internal.services.RegistryPersistence;

public final class MenuPersistence
extends RegistryPersistence {
    private MApplication application;
    private IEclipseContext appContext;
    private ArrayList<MenuAdditionCacheEntry> cacheEntries = new ArrayList();
    private ArrayList<ActionSet> actionContributions = new ArrayList();
    private ArrayList<EditorAction> editorActionContributions = new ArrayList();
    private ArrayList<ViewAction> viewActionContributions = new ArrayList();
    private ArrayList<MMenuContribution> menuContributions = new ArrayList();
    private ArrayList<MToolBarContribution> toolBarContributions = new ArrayList();
    private ArrayList<MTrimContribution> trimContributions = new ArrayList();
    private final Comparator<IConfigurationElement> comparer = new Comparator<IConfigurationElement>(){

        @Override
        public int compare(IConfigurationElement c1, IConfigurationElement c2) {
            return c1.getContributor().getName().compareToIgnoreCase(c2.getContributor().getName());
        }
    };
    private Pattern contributorFilter;

    public MenuPersistence(MApplication application, IEclipseContext appContext) {
        this.application = application;
        this.appContext = appContext;
    }

    public MenuPersistence(MApplication application, IEclipseContext appContext, String filterRegex) {
        this(application, appContext);
        this.contributorFilter = Pattern.compile(filterRegex);
    }

    public void dispose() {
        ControlContributionRegistry.clear();
        this.application.getMenuContributions().removeAll(this.menuContributions);
        this.application.getToolBarContributions().removeAll(this.toolBarContributions);
        this.application.getTrimContributions().removeAll(this.trimContributions);
        this.menuContributions.clear();
        this.cacheEntries.clear();
        this.actionContributions.clear();
        this.editorActionContributions.clear();
        this.viewActionContributions.clear();
        super.dispose();
    }

    protected boolean isChangeImportant(IRegistryChangeEvent event) {
        return false;
    }

    public void reRead() {
        this.read();
    }

    protected final void read() {
        super.read();
        this.readAdditions();
        this.readActionSets();
        this.readEditorActions();
        this.readViewActions();
        ArrayList<MMenuContribution> tmp = new ArrayList<MMenuContribution>(this.menuContributions);
        this.menuContributions.clear();
        ContributionsAnalyzer.mergeContributions(tmp, this.menuContributions);
        this.application.getMenuContributions().addAll(this.menuContributions);
        ArrayList<MToolBarContribution> tmpToolbar = new ArrayList<MToolBarContribution>(this.toolBarContributions);
        this.toolBarContributions.clear();
        ContributionsAnalyzer.mergeToolBarContributions(tmpToolbar, this.toolBarContributions);
        this.application.getToolBarContributions().addAll(this.toolBarContributions);
        ArrayList<MTrimContribution> tmpTrim = new ArrayList<MTrimContribution>(this.trimContributions);
        this.trimContributions.clear();
        ContributionsAnalyzer.mergeTrimContributions(tmpTrim, this.trimContributions);
        this.application.getTrimContributions().addAll(this.trimContributions);
    }

    private void readAdditions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] menusExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int i = 0;
        while (i < menusExtensionPoint.length) {
            if ("menuContribution".equals(menusExtensionPoint[i].getName()) && (this.contributorFilter == null || this.contributorFilter.matcher(menusExtensionPoint[i].getContributor().getName()).matches())) {
                configElements.add(menusExtensionPoint[i]);
            }
            ++i;
        }
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement configElement : configElements) {
            if (this.isProgramaticContribution(configElement)) {
                System.out.println("Programmatic Contribution Factories not supported");
                continue;
            }
            MenuAdditionCacheEntry menuContribution = new MenuAdditionCacheEntry(this.application, this.appContext, configElement, configElement.getAttribute("locationURI"), configElement.getNamespaceIdentifier());
            this.cacheEntries.add(menuContribution);
            menuContribution.mergeIntoModel(this.menuContributions, this.toolBarContributions, this.trimContributions);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readActionSets() {
        void var5_8;
        IConfigurationElement[] extElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.eclipse.ui.actionSets");
        int n = extElements.length;
        boolean n2 = false;
        while (var5_8 < n) {
            IConfigurationElement element = iConfigurationElementArray[var5_8];
            if (this.contributorFilter == null || this.contributorFilter.matcher(element.getContributor().getName()).matches()) {
                configElements.add(element);
            }
            ++var5_8;
        }
        Collections.sort(configElements, this.comparer);
        HashMap<String, ArrayList<MToolBarContribution>> postProcessing = new HashMap<String, ArrayList<MToolBarContribution>>();
        for (IConfigurationElement iConfigurationElement : configElements) {
            ArrayList<MToolBarContribution> localToolbarContributions = new ArrayList<MToolBarContribution>();
            ActionSet actionSet = new ActionSet(this.application, this.appContext, iConfigurationElement);
            this.actionContributions.add(actionSet);
            actionSet.addToModel(this.menuContributions, localToolbarContributions, this.trimContributions);
            this.toolBarContributions.addAll(localToolbarContributions);
            postProcessing.put(actionSet.getId(), localToolbarContributions);
        }
        for (Map.Entry entry : postProcessing.entrySet()) {
            for (MToolBarContribution contribution : (ArrayList)entry.getValue()) {
                ArrayList adjunctContributions;
                String targetParentId = contribution.getParentId();
                if (((String)entry.getKey()).equals(targetParentId) || (adjunctContributions = (ArrayList)postProcessing.get(targetParentId)) == null) continue;
                boolean processed = false;
                Iterator i = adjunctContributions.iterator();
                block4: while (i.hasNext() && !processed) {
                    MToolBarContribution adjunctContribution = (MToolBarContribution)i.next();
                    if (!targetParentId.equals(adjunctContribution.getParentId())) continue;
                    for (MToolBarElement item : adjunctContribution.getChildren()) {
                        if (item instanceof MToolBarSeparator || item.getElementId() == null) continue;
                        processed = true;
                        contribution.setPositionInParent("before=" + item.getElementId());
                        continue block4;
                    }
                }
            }
        }
        postProcessing.clear();
    }

    private void readEditorActions() {
        IConfigurationElement[] extElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.eclipse.ui.editorActions");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (this.contributorFilter == null || this.contributorFilter.matcher(element.getContributor().getName()).matches()) {
                configElements.add(element);
            }
            ++n2;
        }
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement element : configElements) {
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                if (child.getName().equals("action")) {
                    EditorAction editorAction = new EditorAction(this.application, this.appContext, element, child);
                    this.editorActionContributions.add(editorAction);
                    editorAction.addToModel(this.menuContributions, this.toolBarContributions, this.trimContributions);
                }
                ++n4;
            }
        }
    }

    private void readViewActions() {
        IConfigurationElement[] extElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.eclipse.ui.viewActions");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (this.contributorFilter == null || this.contributorFilter.matcher(element.getContributor().getName()).matches()) {
                configElements.add(element);
            }
            ++n2;
        }
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement element : configElements) {
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ViewAction viewAction;
                IConfigurationElement child = iConfigurationElementArray2[n4];
                if (child.getName().equals("action")) {
                    viewAction = new ViewAction(this.application, this.appContext, element, child, false);
                    this.viewActionContributions.add(viewAction);
                    viewAction.addToModel(this.menuContributions, this.toolBarContributions, this.trimContributions);
                } else if (child.getName().equals("menu")) {
                    viewAction = new ViewAction(this.application, this.appContext, element, child, true);
                    this.viewActionContributions.add(viewAction);
                    viewAction.addToModel(this.menuContributions, this.toolBarContributions, this.trimContributions);
                }
                ++n4;
            }
        }
    }

    private boolean isProgramaticContribution(IConfigurationElement menuAddition) {
        return menuAddition.getAttribute("class") != null;
    }
}

