/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabFolder2Adapter;
import org.eclipse.e4.ui.widgets.CTabFolder2Listener;
import org.eclipse.e4.ui.widgets.CTabFolderEvent;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MinMaxAddon {
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    private static String trimURI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack";
    static String ID_SUFFIX = "(minimized)";
    public static String MINIMIZED = "Minimized";
    public static String MAXIMIZED = "Maximized";
    public static String MINIMIZED_BY_ZOOM = "MinimizedByZoom";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private IEclipseContext context;
    private boolean ignoreTagChanges = false;
    private CTabFolder2Adapter CTFButtonListener = new CTabFolder2Adapter(){

        private MUIElement getElementToChange(CTabFolderEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void maximize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MAXIMIZED);
        }

        public void minimize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MINIMIZED);
        }

        public void restore(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), null);
        }
    };
    private MouseListener CTFDblClickListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        private MUIElement getElementToChange(MouseEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                CTabFolder ctf = (CTabFolder)e.widget;
                if (!ctf.getMaximizeVisible()) {
                    return;
                }
                MUIElement elementToChange = this.getElementToChange(e);
                if (!elementToChange.getTags().contains(MAXIMIZED)) {
                    MinMaxAddon.this.setState(elementToChange, MAXIMIZED);
                } else {
                    MinMaxAddon.this.setState(elementToChange, null);
                }
            }
        }
    };
    private EventHandler widgetListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
                return;
            }
            CTabFolder ctf = MinMaxAddon.this.getCTFFor(changedElement);
            if (ctf == null) {
                return;
            }
            MUIElement stateElement = changedElement;
            if (changedElement instanceof MPartStack) {
                MPartStack stack = (MPartStack)changedElement;
                MArea area = MinMaxAddon.this.getAreaFor(stack);
                if (area != null && !(area.getWidget() instanceof CTabFolder)) {
                    stateElement = area.getCurSharedRef();
                }
            } else if (changedElement instanceof MArea) {
                stateElement = changedElement.getCurSharedRef();
            }
            MinMaxAddon.this.adjustCTFButtons(stateElement);
            ctf.removeCTabFolder2Listener((CTabFolder2Listener)MinMaxAddon.this.CTFButtonListener);
            ctf.addCTabFolder2Listener((CTabFolder2Listener)MinMaxAddon.this.CTFButtonListener);
            ctf.removeMouseListener(MinMaxAddon.this.CTFDblClickListener);
            ctf.addMouseListener(MinMaxAddon.this.CTFDblClickListener);
        }
    };
    private EventHandler perspectiveChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack ps = (MPerspectiveStack)changedElement;
            MWindow window = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)ps);
            List tcList = MinMaxAddon.this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
            MPerspective curPersp = (MPerspective)ps.getSelectedElement();
            if (curPersp != null) {
                String perspId = String.valueOf('(') + curPersp.getElementId() + ')';
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack) || !tc.getElementId().contains(perspId)) continue;
                    tc.setVisible(true);
                }
                MPlaceholder eaPlaceholder = (MPlaceholder)MinMaxAddon.this.modelService.find(MinMaxAddon.ID_EDITOR_AREA, (MUIElement)curPersp);
                MinMaxAddon.this.adjustCTFButtons((MUIElement)eaPlaceholder);
            }
            if (event.getProperty("OldValue") instanceof MPerspective) {
                MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
                String perspId = String.valueOf('(') + oldPersp.getElementId() + ')';
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack) || !tc.getElementId().contains(perspId)) continue;
                    TrimStack ts = (TrimStack)tc.getObject();
                    ts.showStack(false);
                    tc.setVisible(false);
                }
            }
            final Shell winShell = (Shell)window.getWidget();
            winShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    winShell.layout(true, true);
                }
            });
        }
    };
    private EventHandler tagChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            if (MinMaxAddon.this.ignoreTagChanges) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            String eventType = (String)event.getProperty("EventType");
            String tag = (String)event.getProperty("NewValue");
            String oldVal = (String)event.getProperty("OldValue");
            if (!(changedObj instanceof MUIElement)) {
                return;
            }
            MUIElement changedElement = (MUIElement)changedObj;
            if ("ADD".equals(eventType)) {
                if (MINIMIZED.equals(tag)) {
                    MinMaxAddon.this.minimize(changedElement);
                } else if (MAXIMIZED.equals(tag)) {
                    MinMaxAddon.this.maximize(changedElement);
                }
            } else if ("REMOVE".equals(eventType)) {
                if (MINIMIZED.equals(oldVal)) {
                    MinMaxAddon.this.restore(changedElement);
                } else if (MAXIMIZED.equals(oldVal)) {
                    MinMaxAddon.this.unzoom(changedElement);
                }
            }
        }
    };
    private EventHandler perspectiveRemovedListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("REMOVE".equals(eventType)) {
                MUIElement removed = (MUIElement)event.getProperty("OldValue");
                String perspectiveId = removed.getElementId();
                MWindow window = MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                MTrimBar bar = MinMaxAddon.this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MUIElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    };

    private void setState(MUIElement element, String state) {
        element.getTags().remove(MINIMIZED_BY_ZOOM);
        if (MINIMIZED.equals(state)) {
            element.getTags().remove(MAXIMIZED);
            element.getTags().add(MINIMIZED);
        } else if (MAXIMIZED.equals(state)) {
            element.getTags().remove(MINIMIZED);
            element.getTags().add(MAXIMIZED);
        } else {
            element.getTags().remove(MINIMIZED);
            element.getTags().remove(MAXIMIZED);
        }
    }

    @PostConstruct
    void hookListeners() {
        String topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget");
        this.eventBroker.subscribe(topic, null, this.widgetListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children");
        this.eventBroker.subscribe(topic, null, this.perspectiveRemovedListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement");
        this.eventBroker.subscribe(topic, null, this.perspectiveChangeListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ApplicationElement", (String)"tags");
        this.eventBroker.subscribe(topic, null, this.tagChangeListener, false);
    }

    @PreDestroy
    void unhookListeners() {
        this.eventBroker.unsubscribe(this.widgetListener);
        this.eventBroker.unsubscribe(this.perspectiveRemovedListener);
        this.eventBroker.unsubscribe(this.perspectiveChangeListener);
        this.eventBroker.unsubscribe(this.tagChangeListener);
    }

    private MArea getAreaFor(MPartStack stack) {
        MElementContainer parent = stack.getParent();
        while (parent != null) {
            if (parent instanceof MArea) {
                return (MArea)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void setCTFButtons(CTabFolder ctf, MUIElement stateElement, boolean hideButtons) {
        if (hideButtons) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(false);
        } else if (stateElement.getTags().contains(MINIMIZED)) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else if (stateElement.getTags().contains(MAXIMIZED)) {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMinimized(false);
            ctf.setMaximized(false);
            ctf.layout();
        }
    }

    private void adjustCTFButtons(MUIElement element) {
        if (!(element instanceof MPartStack) && !(element instanceof MPlaceholder)) {
            return;
        }
        CTabFolder ctf = this.getCTFFor(element);
        if (ctf == null) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.setCTFButtons(ctf, element, false);
        } else {
            MArea area = this.getAreaFor((MPartStack)element);
            if (area == null) {
                this.setCTFButtons(ctf, element, false);
            }
        }
    }

    private CTabFolder getCTFFor(MUIElement element) {
        if (element instanceof MArea) {
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            List stacks = this.modelService.findElements(element, null, MPartStack.class, null);
            for (MPartStack stack : stacks) {
                if (!(stack.getWidget() instanceof CTabFolder)) continue;
                return (CTabFolder)stack.getWidget();
            }
        } else {
            MPlaceholder ph;
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() instanceof MArea) {
                return this.getCTFFor(ph.getRef());
            }
        }
        return null;
    }

    void minimize(MUIElement element) {
        this.createTrim(element);
        element.setVisible(false);
        this.adjustCTFButtons(element);
    }

    void restore(MUIElement element) {
        MWindow window = this.modelService.getTopLevelWindowFor(element);
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        TrimStack ts = (TrimStack)trimStack.getObject();
        ts.restoreStack();
        this.adjustCTFButtons(element);
        element.getTags().remove(MINIMIZED_BY_ZOOM);
    }

    void maximize(MUIElement element) {
        MPlaceholder eaPlaceholder;
        MWindow win = this.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<String> maxTag = new ArrayList<String>();
        maxTag.add(MAXIMIZED);
        List curMax = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MUIElement.class, maxTag);
        if (curMax.size() > 0) {
            for (MUIElement maxElement : curMax) {
                if (maxElement == element) continue;
                this.ignoreTagChanges = true;
                try {
                    maxElement.getTags().remove(MAXIMIZED);
                }
                finally {
                    this.ignoreTagChanges = false;
                }
            }
        }
        List stacks = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPartStack.class, null, 11);
        for (MPartStack theStack : stacks) {
            int loc;
            if (theStack == element || this.getWindowFor((MUIElement)theStack) != win || (loc = this.modelService.getElementLocation((MUIElement)theStack)) == 8 || theStack.getWidget() == null || theStack.getTags().contains(MINIMIZED)) continue;
            theStack.getTags().add(MINIMIZED_BY_ZOOM);
            theStack.getTags().add(MINIMIZED);
        }
        if (persp != null && element != (eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)persp)) && eaPlaceholder != null) {
            eaPlaceholder.getTags().add(MINIMIZED_BY_ZOOM);
            eaPlaceholder.getTags().add(MINIMIZED);
        }
        this.adjustCTFButtons(element);
    }

    private MWindow getWindowFor(MUIElement element) {
        MElementContainer parent = element.getParent();
        while (parent != null && !(parent instanceof MWindow)) {
            parent = parent.getParent();
        }
        return (MWindow)parent;
    }

    void unzoom(MUIElement element) {
        MWindow win = this.modelService.getTopLevelWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        List stacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null, 11);
        for (MPartStack theStack : stacks) {
            if (theStack.getWidget() == null || !theStack.getTags().contains(MINIMIZED) || !theStack.getTags().contains(MINIMIZED_BY_ZOOM)) continue;
            theStack.getTags().remove(MINIMIZED);
        }
        MPlaceholder eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)(persp == null ? win : persp));
        if (element != eaPlaceholder && eaPlaceholder != null) {
            eaPlaceholder.getTags().remove(MINIMIZED);
        }
        this.adjustCTFButtons(element);
    }

    private void createTrim(MUIElement element) {
        MTrimmedWindow window = (MTrimmedWindow)this.getWindowFor(element);
        Shell winShell = (Shell)window.getWidget();
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(trimURI);
            Rectangle winBounds = winShell.getBounds();
            int winCenterX = winBounds.width / 2;
            Control stackCtrl = (Control)element.getWidget();
            Rectangle stackBounds = stackCtrl.getBounds();
            stackBounds = winShell.getDisplay().map(stackCtrl, (Control)winShell, stackBounds);
            int stackCenterX = stackBounds.x + stackBounds.width / 2;
            SideValue side = stackCenterX < winCenterX ? SideValue.LEFT : SideValue.RIGHT;
            MTrimBar bar = this.modelService.getTrim(window, side);
            bar.getChildren().add(trimStack);
            bar.setVisible(true);
            if (bar.getWidget() == null) {
                bar.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)bar, (Object)winShell, window.getContext());
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
            trimStack.setToBeRendered(true);
        }
    }

    private String getMinimizedElementSuffix(MUIElement element) {
        String id = ID_SUFFIX;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            id = String.valueOf('(') + persp.getElementId() + ')';
        }
        return id;
    }
}

