/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.product.VersionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.feature.NewFeatureProjectWizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureSection
extends TableSection
implements IPropertyChangeListener {
    private SortAction fSortAction;
    private Action fNewFeatureAction;
    private TableViewer fFeatureTable;

    public FeatureSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, FeatureSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_FeatureSection_add, PDEUIMessages.Product_FeatureSection_remove, PDEUIMessages.Product_PluginSection_removeAll, PDEUIMessages.Product_FeatureSection_properties, PDEUIMessages.Product_FeatureSection_up, PDEUIMessages.Product_FeatureSection_down};
        return labels;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        EditableTablePart tablePart = this.getTablePart();
        this.fFeatureTable = tablePart.getTableViewer();
        this.fFeatureTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fFeatureTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fFeatureTable.setSorter(null);
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        this.fFeatureTable.setInput((Object)PDECore.getDefault().getFeatureModelManager());
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(3, this.isEditable());
        tablePart.setButtonEnabled(4, this.isEditable());
        tablePart.setButtonEnabled(5, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setText(PDEUIMessages.Product_FeatureSection_title);
        section.setDescription(PDEUIMessages.Product_FeatureSection_desc);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fNewFeatureAction = new NewFeatureAction();
        toolBarManager.add((IAction)this.fNewFeatureAction);
        this.fSortAction = new SortAction((StructuredViewer)this.fFeatureTable, PDEUIMessages.Product_FeatureSection_sortAlpha, null, null, this);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleDelete();
                break;
            }
            case 2: {
                this.handleRemoveAll();
                break;
            }
            case 3: {
                this.handleProperties();
                break;
            }
            case 4: {
                this.handleUp();
                break;
            }
            case 5: {
                this.handleDown();
            }
        }
    }

    private void handleProperties() {
        IStructuredSelection ssel = (IStructuredSelection)this.fFeatureTable.getSelection();
        if (ssel.size() == 1) {
            IProductFeature feature = (IProductFeature)ssel.toArray()[0];
            VersionDialog dialog = new VersionDialog(PDEPlugin.getActiveWorkbenchShell(), this.isEditable(), feature.getVersion());
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 200);
            if (dialog.open() == 0) {
                feature.setVersion(dialog.getVersion());
            }
        }
    }

    private void handleNewFeature() {
        NewFeatureProjectWizard wizard = new NewFeatureProjectWizard();
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            this.addFeature(wizard.getFeatureId(), wizard.getFeatureVersion());
        }
    }

    private void addFeature(String id, String version) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductFeature feature = factory.createFeature();
        feature.setId(id);
        feature.setVersion(version);
        product.addFeatures(new IProductFeature[]{feature});
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removeFeatures(product.getFeatures());
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IProductFeature) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void doPaste(Object target, Object[] objects) {
        IProductFeature[] features;
        if (objects instanceof IProductFeature[]) {
            features = (IProductFeature[])objects;
        } else {
            features = new IProductFeature[objects.length];
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductFeature) {
                    features[i] = (IProductFeature)objects[i];
                }
                ++i;
            }
        }
        this.getProduct().addFeatures(features);
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fFeatureTable.getSelection();
        if (ssel.size() > 0) {
            Object[] objects = ssel.toArray();
            IProductFeature[] features = new IProductFeature[objects.length];
            System.arraycopy(objects, 0, features, 0, objects.length);
            this.getProduct().removeFeatures(features);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = (IStructuredSelection)this.fFeatureTable.getSelection();
        if (ssel == null) {
            return;
        }
        Action openAction = new Action(PDEUIMessages.Product_FeatureSection_open){

            public void run() {
                FeatureSection.this.handleDoubleClick((IStructuredSelection)FeatureSection.this.fFeatureTable.getSelection());
            }
        };
        openAction.setEnabled(this.isEditable() && ssel.size() == 1);
        manager.add((IAction)openAction);
        manager.add((IContributionItem)new Separator());
        Action removeAction = new Action(PDEUIMessages.Product_FeatureSection_remove){

            public void run() {
                FeatureSection.this.handleDelete();
            }
        };
        removeAction.setEnabled(this.isEditable() && ssel.size() > 0);
        manager.add((IAction)removeAction);
        Action removeAll = new Action(PDEUIMessages.FeatureSection_removeAll){

            public void run() {
                FeatureSection.this.handleRemoveAll();
            }
        };
        removeAll.setEnabled(this.isEditable());
        manager.add((IAction)removeAll);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleOpen(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IProductFeature feature = (IProductFeature)selection.getFirstElement();
            FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
            IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
            FeatureEditor.openFeatureEditor(model);
        }
    }

    private void handleAdd() {
        FeatureSelectionDialog dialog = new FeatureSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getAvailableChoices(), true);
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            int i = 0;
            while (i < models.length) {
                IFeature feature = ((IFeatureModel)models[i]).getFeature();
                this.addFeature(feature.getId(), feature.getVersion());
                ++i;
            }
        }
    }

    private IFeatureModel[] getAvailableChoices() {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        IProduct product = this.getProduct();
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        int i = 0;
        while (i < models.length) {
            String id = models[i].getFeature().getId();
            if (id != null && !product.containsFeature(id)) {
                list.add(models[i]);
            }
            ++i;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object[] objects = e.getChangedObjects();
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        if (e.getChangeType() == 1) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductFeature) {
                    this.fFeatureTable.add(objects[i]);
                }
                ++i;
            }
        } else if (e.getChangeType() == 2) {
            Table table = this.fFeatureTable.getTable();
            int index = table.getSelectionIndex();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductFeature) {
                    this.fFeatureTable.remove(objects[i]);
                }
                ++i;
            }
            int count = table.getItemCount();
            if (count != 0) {
                if (index < count) {
                    table.setSelection(index);
                } else {
                    table.setSelection(count - 1);
                }
            }
        } else if (e.getChangeType() == 3) {
            this.fFeatureTable.refresh();
        }
        this.updateButtons(false, true);
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        if (this.fFeatureTable.getTable().isDisposed()) {
            return;
        }
        this.fFeatureTable.setInput((Object)PDECore.getDefault().getFeatureModelManager());
        this.refresh();
    }

    public void refresh() {
        this.fFeatureTable.refresh();
        this.updateButtons(true, true);
        super.refresh();
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons(true, false);
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IProductFeature) {
            this.fFeatureTable.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    private void updateButtons(boolean updateRemove, boolean updateRemoveAll) {
        boolean hasSelection;
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        boolean bl = hasSelection = tableSelection.length > 0;
        if (updateRemove) {
            ISelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(1, this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IProductFeature);
        }
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(2, this.isEditable() && this.fFeatureTable.getTable().getItemCount() > 0);
        }
        tablePart.setButtonEnabled(3, this.isEditable() && hasSelection);
        boolean canMove = table.getItemCount() > 1 && tableSelection.length == 1 && !this.fSortAction.isChecked();
        tablePart.setButtonEnabled(4, canMove && this.isEditable() && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(5, canMove && hasSelection && this.isEditable() && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected boolean createCount() {
        return true;
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IProductFeature feature1 = (IProductFeature)table.getItem(index1).getData();
        IProductFeature feature2 = (IProductFeature)table.getItem(index2).getData();
        IProduct product = this.getProduct();
        product.swap(feature1, feature2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (((Object)((Object)this.fSortAction)).equals(event.getSource()) && "result".equals(event.getProperty())) {
            this.updateButtons(true, true);
        }
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return FeatureSection.this.getProduct().getFeatures();
        }
    }

    class NewFeatureAction
    extends Action {
        public NewFeatureAction() {
            super(PDEUIMessages.Product_FeatureSection_newFeature, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_NEWFTRPRJ_TOOL);
        }

        public void run() {
            FeatureSection.this.handleNewFeature();
        }
    }
}

