/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    int currentEffect = 0;
    TableItem currentItem;
    PaintListener paintListener;
    TableItem dropSelection = null;
    TableItem scrollItem;
    long scrollBeginTime;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void dragEnter(DropTargetEvent event) {
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
        this.currentItem = null;
        this.dropSelection = null;
    }

    public void dragLeave(DropTargetEvent event) {
        Table table = (Table)this.control;
        if (this.currentItem != null) {
            this.setDropSelection(table, null);
            this.currentItem = null;
        }
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        Table table = (Table)this.control;
        int effect = this.checkEffect(event.feedback);
        TableItem item = (TableItem)this.getItem(table, event.x, event.y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int index;
                Rectangle area = table.getClientArea();
                int headerHeight = table.getHeaderHeight();
                int itemHeight = table.getItemHeight();
                Point pt = new Point(event.x, event.y);
                pt = table.getDisplay().map(null, (Control)table, pt);
                TableItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    index = Math.max(0, table.indexOf(item) - 1);
                    nextItem = table.getItem(index);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    index = Math.min(table.getItemCount() - 1, table.indexOf(item) + 1);
                    nextItem = table.getItem(index);
                }
                if (nextItem != null) {
                    table.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        if ((effect & 1) != 0) {
            if (this.currentItem != item || (this.currentEffect & 1) == 0) {
                this.setDropSelection(table, item);
                this.currentEffect = effect;
                this.currentItem = item;
            }
        } else {
            this.setDropSelection(table, null);
        }
    }

    void setDropSelection(Table table, TableItem item) {
        Rectangle bounds;
        if (item == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds(0);
            table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        this.dropSelection = item;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds(0);
            table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        if (this.dropSelection == null) {
            if (this.paintListener != null) {
                table.removePaintListener(this.paintListener);
                this.paintListener = null;
            }
        } else if (this.paintListener == null) {
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (TableDropTargetEffect.this.dropSelection == null || TableDropTargetEffect.this.dropSelection.isDisposed()) {
                        return;
                    }
                    GC gc = e.gc;
                    boolean xor = gc.getXORMode();
                    gc.setXORMode(true);
                    Rectangle bounds = TableDropTargetEffect.this.dropSelection.getBounds(0);
                    gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    gc.setXORMode(xor);
                }
            };
            table.addPaintListener(this.paintListener);
        }
    }
}

