/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.server;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.jmx.internal.server.Activator;
import org.eclipse.equinox.jmx.server.ContributionProvider;

public class ServerExtensionManager
extends Observable
implements IRegistryChangeListener {
    private static Map providers;
    private static ServerExtensionManager instance;

    private ServerExtensionManager() {
        providers = new Hashtable();
        this.initExtensions();
    }

    public static ServerExtensionManager getInstance() {
        if (instance == null) {
            instance = new ServerExtensionManager();
        }
        return instance;
    }

    public Collection getContributionExtensionDefinitions() {
        return providers.values();
    }

    public ContributionExtensionDefinition getContributionExtensionDefinition(String providerClassName) {
        return (ContributionExtensionDefinition)providers.get(providerClassName);
    }

    private void initExtensions() {
        this.registerContributions();
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    private void registerContributions() {
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.equinox.jmx.server", "contribution");
        IExtension[] types = point.getExtensions();
        int i = 0;
        while (i < types.length) {
            this.registerContribution(types[i]);
            ++i;
        }
    }

    private void registerContribution(IExtension ext) {
        IConfigurationElement[] configElems = ext.getConfigurationElements();
        int j = 0;
        while (j < configElems.length) {
            ContributionExtensionDefinition defn = new ContributionExtensionDefinition(configElems[j]);
            if (defn.getContributionProvider() == null) {
                defn = (ContributionExtensionDefinition)providers.remove(defn.getProviderClassName());
            } else {
                providers.put(defn.getProviderClassName(), defn);
            }
            this.setChanged();
            this.notifyObservers(defn);
            ++j;
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.equinox.jmx.server", "contribution");
        int i = 0;
        while (i < deltas.length) {
            IExtensionDelta delta = deltas[i];
            this.registerContribution(delta.getExtension());
            ++i;
        }
    }

    public static class ContributionExtensionDefinition {
        private static final String ATTRIBUTE_CLASS = "class";
        private static final String ATTRIBUTE_IS_ROOT = "isroot";
        private static final String ELEMENT_CONTRIBUTION = "contribution";
        private static final String ELEMENT_EXTENDS_CLASS = "extendsClass";
        private String providerClassName;
        private boolean isRootProvider;
        private Set extendsClasses;
        private ContributionProvider provider;

        ContributionExtensionDefinition(IConfigurationElement contribElem) {
            String elementName = contribElem.getName();
            if (elementName.equalsIgnoreCase(ELEMENT_CONTRIBUTION) && (this.providerClassName = contribElem.getAttribute(ATTRIBUTE_CLASS)) != null) {
                try {
                    Object obj = contribElem.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (obj instanceof ContributionProvider) {
                        this.provider = (ContributionProvider)obj;
                        String attrIsRoot = null;
                        attrIsRoot = contribElem.getAttribute(ATTRIBUTE_IS_ROOT);
                        if (attrIsRoot != null) {
                            this.isRootProvider = attrIsRoot.equals("true");
                        }
                        IConfigurationElement[] extendsElems = contribElem.getChildren(ELEMENT_EXTENDS_CLASS);
                        this.extendsClasses = new TreeSet();
                        int j = 0;
                        while (j < extendsElems.length) {
                            IConfigurationElement extendsElem = extendsElems[j];
                            this.extendsClasses.add(extendsElem.getAttribute(ATTRIBUTE_CLASS));
                            ++j;
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.logError(e);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String getProviderClassName() {
            return this.providerClassName;
        }

        public boolean isRootProvider() {
            return this.isRootProvider;
        }

        public ContributionProvider getContributionProvider() {
            return this.provider;
        }

        public Set getExtendsClasses() {
            return this.extendsClasses;
        }
    }
}

