/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;

public class TightSourceRangeComputer
extends TargetSourceRangeComputer {
    private HashSet fTightSourceRangeNodes = new HashSet();

    public void addTightSourceNode(ASTNode reference) {
        this.fTightSourceRangeNodes.add(reference);
        List properties = reference.structuralPropertiesForType();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            StructuralPropertyDescriptor descriptor = (StructuralPropertyDescriptor)iterator.next();
            if (descriptor.isChildProperty()) {
                ASTNode child = (ASTNode)reference.getStructuralProperty(descriptor);
                if (child == null || !this.isExtending(child, reference)) continue;
                this.addTightSourceNode(child);
                continue;
            }
            if (!descriptor.isChildListProperty()) continue;
            List childs = (List)reference.getStructuralProperty(descriptor);
            Iterator iterator2 = childs.iterator();
            while (iterator2.hasNext()) {
                ASTNode child = (ASTNode)iterator2.next();
                if (!this.isExtending(child, reference)) continue;
                this.addTightSourceNode(child);
            }
        }
    }

    public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
        if (this.fTightSourceRangeNodes.contains(node)) {
            return new TargetSourceRangeComputer.SourceRange(node.getStartPosition(), node.getLength());
        }
        return super.computeSourceRange(node);
    }

    private boolean isExtending(ASTNode child, ASTNode parent) {
        int extendedEnd;
        int extendedStart;
        TargetSourceRangeComputer.SourceRange extendedRange = super.computeSourceRange(child);
        int parentStart = parent.getStartPosition();
        if (parentStart > (extendedStart = extendedRange.getStartPosition())) {
            return true;
        }
        int parentEnd = parentStart + parent.getLength();
        return parentEnd < (extendedEnd = extendedStart + extendedRange.getLength());
    }
}

