/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import javax.annotation.PostConstruct;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class CompatibilityWorkbenchWindowControlContribution {
    public static final String CONTROL_CONTRIBUTION_URI = "platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.menus.CompatibilityWorkbenchWindowControlContribution";

    @PostConstruct
    void construct(MWindow window, MToolControl toolControl, Composite composite) {
        WorkbenchWindowControlContribution contribution;
        IConfigurationElement configurationElement = ControlContributionRegistry.get(toolControl.getElementId());
        if (configurationElement != null && (contribution = (WorkbenchWindowControlContribution)((Object)Util.safeLoadExecutableExtension(configurationElement, "class", WorkbenchWindowControlContribution.class))) != null) {
            IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class);
            contribution.setWorkbenchWindow(workbenchWindow);
            if (contribution instanceof IWorkbenchContribution) {
                ((IWorkbenchContribution)((Object)contribution)).initialize(workbenchWindow);
            }
            MElementContainer parent = toolControl.getParent();
            while (!(parent instanceof MTrimBar)) {
                parent = parent.getParent();
            }
            switch (((MTrimBar)parent).getSide()) {
                case BOTTOM: {
                    contribution.setCurSide(1024);
                    break;
                }
                case LEFT: {
                    contribution.setCurSide(16384);
                    break;
                }
                case RIGHT: {
                    contribution.setCurSide(131072);
                    break;
                }
                case TOP: {
                    contribution.setCurSide(128);
                }
            }
            contribution.delegateCreateControl(composite);
        }
    }
}

