/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public class PerformRefactoringHistoryOperation
implements IWorkspaceRunnable {
    private RefactoringStatus fExecutionStatus = new RefactoringStatus();
    private final RefactoringHistory fRefactoringHistory;

    public PerformRefactoringHistoryOperation(RefactoringHistory history) {
        Assert.isNotNull((Object)((Object)history));
        this.fRefactoringHistory = history;
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)((Object)refactoring));
        Assert.isNotNull((Object)descriptor);
        return new RefactoringStatus();
    }

    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        return descriptor.createRefactoring(status);
    }

    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        try {
            Assert.isNotNull((Object)descriptor);
            Refactoring refactoring = this.createRefactoring(descriptor, status);
            return refactoring;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public final RefactoringStatus getExecutionStatus() {
        return this.fExecutionStatus;
    }

    protected void refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        Assert.isNotNull((Object)((Object)refactoring));
        Assert.isNotNull((Object)monitor);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.fExecutionStatus = new RefactoringStatus();
        RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
        monitor.beginTask(RefactoringCoreMessages.PerformRefactoringHistoryOperation_perform_refactorings, 170 * proxies.length);
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            int index = 0;
            while (index < proxies.length) {
                block15: {
                    RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                    if (descriptor != null) {
                        Refactoring refactoring = null;
                        RefactoringStatus status = new RefactoringStatus();
                        try {
                            try {
                                refactoring = this.createRefactoring(descriptor, status, (IProgressMonitor)new SubProgressMonitor(monitor, 30, 2));
                            }
                            catch (CoreException exception) {
                                status.merge(RefactoringStatus.create(exception.getStatus()));
                            }
                            if (refactoring == null || status.hasFatalError()) break block15;
                            PerformRefactoringOperation operation = new PerformRefactoringOperation(refactoring, 6);
                            try {
                                status.merge(this.aboutToPerformRefactoring(refactoring, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 30, 2)));
                                if (!status.hasFatalError()) {
                                    ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
                                    status.merge(operation.getConditionStatus());
                                    if (!status.hasFatalError()) {
                                        status.merge(operation.getValidationStatus());
                                    }
                                }
                            }
                            finally {
                                this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                            }
                        }
                        finally {
                            this.fExecutionStatus.merge(status);
                        }
                    }
                }
                ++index;
            }
        }
        finally {
            service.disconnect();
            monitor.done();
        }
    }
}

