/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.AbstractJavaElementLabelDecorator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;

public class InterfaceIndicatorLabelDecorator
extends AbstractJavaElementLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        try {
            ImageDescriptor overlay = this.getOverlay(element);
            if (overlay == null) {
                return;
            }
            decoration.addOverlay(overlay, 1);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    private ImageDescriptor getOverlay(Object element) throws JavaModelException {
        if (element instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)element;
            if (unit.isOpen()) {
                IType mainType = unit.findPrimaryType();
                if (mainType != null) {
                    return this.getOverlayFromFlags(mainType.getFlags());
                }
                return null;
            }
            String typeName = JavaCore.removeJavaLikeExtension((String)unit.getElementName());
            return this.getOverlayWithSearchEngine((ITypeRoot)unit, typeName);
        }
        if (element instanceof IClassFile) {
            IClassFile classFile = (IClassFile)element;
            if (classFile.isOpen()) {
                return this.getOverlayFromFlags(classFile.getType().getFlags());
            }
            String typeName = classFile.getType().getElementName();
            return this.getOverlayWithSearchEngine((ITypeRoot)classFile, typeName);
        }
        return null;
    }

    private ImageDescriptor getOverlayWithSearchEngine(ITypeRoot element, String typeName) {
        class Result
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            int modifiers;

            public Result(int modifiers) {
                this.modifiers = modifiers;
            }
        }
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element});
        TypeNameRequestor requestor = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (enclosingTypeNames.length == 0 && Flags.isPublic((int)modifiers)) {
                    throw new Result(modifiers);
                }
            }
        };
        try {
            String packName = element.getParent().getElementName();
            int matchRule = 8;
            engine.searchAllTypeNames(packName.toCharArray(), matchRule, typeName.toCharArray(), matchRule, 0, scope, requestor, 3, null);
        }
        catch (Result e) {
            return this.getOverlayFromFlags(e.modifiers);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private ImageDescriptor getOverlayFromFlags(int flags) {
        if (Flags.isAnnotation((int)flags)) {
            return JavaPluginImages.DESC_OVR_ANNOTATION;
        }
        if (Flags.isEnum((int)flags)) {
            return JavaPluginImages.DESC_OVR_ENUM;
        }
        if (Flags.isInterface((int)flags)) {
            return JavaPluginImages.DESC_OVR_INTERFACE;
        }
        if (Flags.isAbstract((int)flags)) {
            return JavaPluginImages.DESC_OVR_ABSTRACT_CLASS;
        }
        return null;
    }

    protected void processDelta(IJavaElementDelta delta, List result) {
        IJavaElement elem = delta.getElement();
        boolean isChanged = delta.getKind() == 4;
        boolean isRemoved = delta.getKind() == 2;
        int flags = delta.getFlags();
        switch (elem.getElementType()) {
            case 2: {
                if (isRemoved || isChanged && (flags & 0x400) != 0) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 3: {
                if (isRemoved || isChanged && ((flags & 0x8000) != 0 || (flags & 0x80) != 0)) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 4: {
                if (isRemoved) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                this.processChildrenDelta(delta, result);
                return;
            }
            case 5: {
                if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                    return;
                }
                if (isChanged && ((flags & 1) != 0 || (flags & 0x4000) != 0)) {
                    if (delta.getAffectedChildren().length == 0) {
                        return;
                    }
                    result.add(elem);
                }
                return;
            }
        }
    }
}

