/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTableManager {
    @Inject
    private IEclipseContext eclipseContext;

    public void addTable(BindingTable table) {
        String contextId = table.getId();
        if (this.eclipseContext.containsKey(contextId)) {
            return;
        }
        this.eclipseContext.set(contextId, (Object)table);
    }

    public void removeTable(BindingTable table) {
        String contextId = table.getId();
        if (!this.eclipseContext.containsKey(contextId)) {
            throw new IllegalArgumentException("Does not contains table " + contextId);
        }
        this.eclipseContext.remove(contextId);
    }

    public BindingTable getTable(String id) {
        return (BindingTable)this.eclipseContext.get(id);
    }

    public ContextSet createContextSet(Collection<Context> contexts) {
        return new ContextSet(contexts);
    }

    public Binding getPerfectMatch(ContextSet contextSet, TriggerSequence triggerSequence) {
        Binding result = null;
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious() && result == null) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null) continue;
            result = table.getPerfectMatch(triggerSequence);
        }
        return result;
    }

    public Binding getBestSequenceFor(ContextSet contextSet, ParameterizedCommand parameterizedCommand) {
        ArrayList bindings = (ArrayList)this.getSequencesFor(contextSet, parameterizedCommand);
        if (bindings.size() == 0) {
            return null;
        }
        return (Binding)bindings.get(0);
    }

    public Collection<Binding> getSequencesFor(ContextSet contextSet, ParameterizedCommand parameterizedCommand) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Collection<Binding> sequences;
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || (sequences = table.getSequencesFor(parameterizedCommand)) == null) continue;
            bindings.addAll(sequences);
        }
        Collections.sort(bindings, BindingTable.BEST_SEQUENCE);
        return bindings;
    }

    public boolean isPartialMatch(ContextSet contextSet, TriggerSequence sequence) {
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || !table.isPartialMatch(sequence)) continue;
            return true;
        }
        return false;
    }

    public Collection<Binding> getPartialMatches(ContextSet contextSet, TriggerSequence sequence) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Collection<Binding> partialMatches;
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || (partialMatches = table.getPartialMatches(sequence)) == null) continue;
            bindings.addAll(partialMatches);
        }
        return bindings;
    }
}

