/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;

public class IDEApplication
implements IApplication,
IExecutableExtension {
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final Integer EXIT_RELAUNCH = new Integer(24);
    public static final String PLUGIN_ID = "org.eclipse.ui.ide.application";

    public Object start(IApplicationContext appContext) throws Exception {
        Display display = this.createDisplay();
        DelayedEventsProcessor processor = new DelayedEventsProcessor(display);
        try {
            Shell shell = WorkbenchPlugin.getSplashShell((Display)display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Dialog.getDefaultImages());
            }
            if (!this.checkInstanceLocation(shell)) {
                WorkbenchPlugin.unsetSplashShell((Display)display);
                Platform.endSplash();
                Integer n = EXIT_OK;
                return n;
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new IDEWorkbenchAdvisor(processor));
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        finally {
            Location instanceLoc;
            if (display != null) {
                display.dispose();
            }
            if ((instanceLoc = Platform.getInstanceLocation()) != null) {
                instanceLoc.release();
            }
        }
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return false;
        }
        if (instanceLoc.isSet()) {
            block13: {
                if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                    return false;
                }
                if (!instanceLoc.lock()) break block13;
                IDEApplication.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockMessage);
                } else {
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                }
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Could not obtain lock for workspace location", (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)e.getMessage());
            }
            return false;
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = false;
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) != null) {
            force = true;
            try {
                if (instanceLoc.setURL(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    IDEApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                return false;
            }
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInUseTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage);
        }
        return false;
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        do {
            new ChooseWorkspaceDialog(shell, launchData, false, true).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        if (url == null) {
            return false;
        }
        String version = IDEApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = IDEWorkbenchMessages.IDEApplication_versionTitle;
        String message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = IDEApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)"Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = IDEApplication.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=1";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

