/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class ExtractClassAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ExtractClassAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ExtractClassAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ExtractClassAction_action_text);
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            IType singleSelectedType = RefactoringAvailabilityTester.getSingleSelectedType(selection);
            this.setEnabled(RefactoringAvailabilityTester.isExtractClassAvailable(singleSelectedType));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            IType singleSelectedType = RefactoringAvailabilityTester.getSingleSelectedType(selection);
            if (RefactoringAvailabilityTester.isExtractClassAvailable(singleSelectedType)) {
                if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)singleSelectedType)) {
                    return;
                }
                RefactoringExecutionStarter.startExtractClassRefactoring(singleSelectedType, this.getShell());
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            IJavaElement element = selection.resolveEnclosingElement();
            if (element != null) {
                IType type = (IType)element.getAncestor(7);
                this.setEnabled(RefactoringAvailabilityTester.isExtractClassAvailable(type));
            } else {
                this.setEnabled(false);
            }
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IType type = RefactoringActions.getEnclosingOrPrimaryType(this.fEditor);
            if (RefactoringAvailabilityTester.isExtractClassAvailable(type)) {
                if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
                    return;
                }
                RefactoringExecutionStarter.startExtractClassRefactoring(type, this.getShell());
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

