/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.keys.IBindingService;

public class QuickAccessDialog
extends PopupDialog {
    private TriggerSequence[] invokingCommandKeySequences;
    private Command invokingCommand;
    private QuickAccessContents contents;
    private KeyAdapter keyAdapter;
    private Text filterText;
    private IWorkbenchWindow window;
    private LinkedList previousPicksList = new LinkedList();
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    protected Map textMap = new HashMap();
    protected Map elementMap = new HashMap();
    protected Map providerMap;

    public QuickAccessDialog(IWorkbenchWindow window, final Command invokingCommand) {
        super(ProgressManagerUtil.getDefaultParent(), 16, true, true, false, true, true, null, QuickAccessMessages.QuickAccess_StartTypingToFindMatches);
        this.window = window;
        BusyIndicator.showWhile((Display)(window.getShell() == null ? null : window.getShell().getDisplay()), (Runnable)new Runnable(){

            public void run() {
                QuickAccessProvider[] providers = new QuickAccessProvider[]{new PreviousPicksProvider(), new EditorProvider(), new ViewProvider(), new PerspectiveProvider(), new CommandProvider(), new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
                QuickAccessDialog.this.providerMap = new HashMap();
                int i = 0;
                while (i < providers.length) {
                    QuickAccessDialog.this.providerMap.put(providers[i].getId(), providers[i]);
                    ++i;
                }
                QuickAccessDialog.this.contents = new QuickAccessContents(providers){

                    void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
                        if (filterTextEmpty) {
                            QuickAccessDialog.this.setInfoText(QuickAccessMessages.QuickAccess_StartTypingToFindMatches);
                        } else {
                            TriggerSequence[] sequences = QuickAccessDialog.this.getInvokingCommandKeySequences();
                            if (showAllMatches || sequences == null || sequences.length == 0) {
                                QuickAccessDialog.this.setInfoText("");
                            } else {
                                QuickAccessDialog.this.setInfoText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowAllMatches, (Object)sequences[0].format()));
                            }
                        }
                    }

                    void doClose() {
                        QuickAccessDialog.this.close();
                    }

                    void addPreviousPick(String text, Object element) {
                        QuickAccessDialog.this.previousPicksList.remove(element);
                        if (QuickAccessDialog.this.previousPicksList.size() == 60) {
                            Object removedElement = QuickAccessDialog.this.previousPicksList.removeLast();
                            ArrayList removedList = (ArrayList)(this).QuickAccessDialog.this.textMap.remove(removedElement);
                            int i = 0;
                            while (i < removedList.size()) {
                                (this).QuickAccessDialog.this.elementMap.remove(removedList.get(i));
                                ++i;
                            }
                        }
                        QuickAccessDialog.this.previousPicksList.addFirst(element);
                        ArrayList textList = (ArrayList)(this).QuickAccessDialog.this.textMap.get(element);
                        if (textList == null) {
                            textList = new ArrayList();
                            (this).QuickAccessDialog.this.textMap.put(element, textList);
                        }
                        textList.remove(text);
                        if (textList.size() == 3) {
                            Object removedText = textList.remove(0);
                            (this).QuickAccessDialog.this.elementMap.remove(removedText);
                        }
                        if (text.length() > 0) {
                            textList.add(text);
                            Object replacedElement = (this).QuickAccessDialog.this.elementMap.put(text, element);
                            if (replacedElement != null && !replacedElement.equals(element) && (textList = (ArrayList)(this).QuickAccessDialog.this.textMap.get(replacedElement)) != null) {
                                textList.remove(text);
                                if (textList.isEmpty()) {
                                    (this).QuickAccessDialog.this.textMap.remove(replacedElement);
                                    QuickAccessDialog.this.previousPicksList.remove(replacedElement);
                                }
                            }
                        }
                    }

                    QuickAccessElement getPerfectMatch(String filter) {
                        QuickAccessElement perfectMatch = (QuickAccessElement)(this).QuickAccessDialog.this.elementMap.get(filter);
                        return perfectMatch;
                    }

                    void handleElementSelected(String text, Object selectedElement) {
                        if (selectedElement instanceof QuickAccessElement) {
                            this.addPreviousPick(text, selectedElement);
                            QuickAccessDialog.this.storeDialog(this.getDialogSettings());
                            QuickAccessElement element = (QuickAccessElement)selectedElement;
                            element.execute();
                        }
                    }
                };
                QuickAccessDialog.this.restoreDialog();
                QuickAccessDialog.this.invokingCommand = invokingCommand;
                if (QuickAccessDialog.this.invokingCommand != null && !QuickAccessDialog.this.invokingCommand.isDefined()) {
                    QuickAccessDialog.this.invokingCommand = null;
                } else {
                    QuickAccessDialog.this.getInvokingCommandKeySequences();
                }
                QuickAccessDialog.this.create();
            }
        });
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = QuickAccessDialog.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    Point size = shell.getSize();
                    shell.setSize(size.x, size.y + 1);
                }
            }
        });
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = new Text(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filterText);
        this.contents.hookFilterText(this.filterText);
        return this.filterText;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        boolean isWin32 = Util.isWindows();
        GridLayoutFactory.fillDefaults().extendedMargins(isWin32 ? 0 : 3, 3, 2, 2).applyTo(composite);
        Table table = this.contents.createTable(composite, QuickAccessDialog.getDefaultOrientation());
        table.addKeyListener((KeyListener)this.getKeyAdapter());
        return composite;
    }

    protected final TriggerSequence[] getInvokingCommandKeySequences() {
        if (this.invokingCommandKeySequences == null && this.invokingCommand != null) {
            IBindingService bindingService = (IBindingService)this.window.getWorkbench().getAdapter(IBindingService.class);
            this.invokingCommandKeySequences = bindingService.getActiveBindingsFor(this.invokingCommand.getId());
        }
        return this.invokingCommandKeySequences;
    }

    private KeyAdapter getKeyAdapter() {
        if (this.keyAdapter == null) {
            this.keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    TriggerSequence[] sequences = QuickAccessDialog.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            QuickAccessDialog.this.contents.toggleShowAllMatches();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.keyAdapter;
    }

    protected Control getFocusControl() {
        return this.filterText;
    }

    public boolean close() {
        this.storeDialog(this.getDialogSettings());
        return super.close();
    }

    protected Point getDefaultSize() {
        return new Point(350, 420);
    }

    protected Point getDefaultLocation(Point initialSize) {
        Point size = new Point(400, 400);
        Rectangle parentBounds = this.getParentShell().getBounds();
        int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
        int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
        return new Point(x, y);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    protected String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    private void storeDialog(IDialogSettings dialogSettings) {
        String[] orderedElements = new String[this.previousPicksList.size()];
        String[] orderedProviders = new String[this.previousPicksList.size()];
        String[] textEntries = new String[this.previousPicksList.size()];
        ArrayList arrayList = new ArrayList();
        int i = 0;
        while (i < orderedElements.length) {
            QuickAccessElement quickAccessElement = (QuickAccessElement)this.previousPicksList.get(i);
            ArrayList elementText = (ArrayList)this.textMap.get(quickAccessElement);
            Assert.isNotNull((Object)elementText);
            orderedElements[i] = quickAccessElement.getId();
            orderedProviders[i] = quickAccessElement.getProvider().getId();
            arrayList.addAll(elementText);
            textEntries[i] = String.valueOf(elementText.size());
            ++i;
        }
        String[] textArray = arrayList.toArray(new String[arrayList.size()]);
        dialogSettings.put(ORDERED_ELEMENTS, orderedElements);
        dialogSettings.put(ORDERED_PROVIDERS, orderedProviders);
        dialogSettings.put(TEXT_ENTRIES, textEntries);
        dialogSettings.put(TEXT_ARRAY, textArray);
    }

    private void restoreDialog() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] orderedElements = dialogSettings.getArray(ORDERED_ELEMENTS);
            String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
            String[] textEntries = dialogSettings.getArray(TEXT_ENTRIES);
            String[] textArray = dialogSettings.getArray(TEXT_ARRAY);
            this.elementMap = new HashMap();
            this.textMap = new HashMap();
            this.previousPicksList = new LinkedList();
            if (orderedElements != null && orderedProviders != null && textEntries != null && textArray != null) {
                int arrayIndex = 0;
                int i = 0;
                while (i < orderedElements.length) {
                    QuickAccessElement quickAccessElement;
                    QuickAccessProvider quickAccessProvider = (QuickAccessProvider)this.providerMap.get(orderedProviders[i]);
                    int numTexts = Integer.parseInt(textEntries[i]);
                    if (quickAccessProvider != null && (quickAccessElement = quickAccessProvider.getElementForId(orderedElements[i])) != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int j = arrayIndex;
                        while (j < arrayIndex + numTexts) {
                            String text = textArray[j];
                            if (text.length() > 0) {
                                arrayList.add(text);
                                this.elementMap.put(text, quickAccessElement);
                            }
                            ++j;
                        }
                        this.textMap.put(quickAccessElement, arrayList);
                        this.previousPicksList.add(quickAccessElement);
                    }
                    arrayIndex += numTexts;
                    ++i;
                }
            }
        }
    }

    private class PreviousPicksProvider
    extends QuickAccessProvider {
        private PreviousPicksProvider() {
        }

        public QuickAccessElement getElementForId(String id) {
            return null;
        }

        public QuickAccessElement[] getElements() {
            return QuickAccessDialog.this.previousPicksList.toArray(new QuickAccessElement[QuickAccessDialog.this.previousPicksList.size()]);
        }

        public QuickAccessElement[] getElementsSorted() {
            return this.getElements();
        }

        public String getId() {
            return "org.eclipse.ui.previousPicks";
        }

        public ImageDescriptor getImageDescriptor() {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
        }

        public String getName() {
            return QuickAccessMessages.QuickAccess_Previous;
        }

        public boolean isAlwaysPresent() {
            return true;
        }

        protected void doReset() {
        }
    }
}

