/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;

public class ListenerQueue {
    protected final EventManager manager;
    private final Map queue;
    private boolean readOnly;

    public ListenerQueue(EventManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = manager;
        this.queue = new CopyOnWriteIdentityMap();
        this.readOnly = false;
    }

    public void queueListeners(EventListeners listeners, EventDispatcher dispatcher) {
        this.queueListeners(listeners.entrySet(), dispatcher);
    }

    public synchronized void queueListeners(Set listeners, EventDispatcher dispatcher) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (listeners.size() != 0) {
            this.queue.put(listeners, dispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventAsynchronous(int eventAction, Object eventObject) {
        EventManager.EventThread eventThread;
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.readOnly = true;
        }
        EventManager.EventThread eventThread2 = eventThread = this.manager.getEventThread();
        synchronized (eventThread2) {
            Iterator iter = this.queue.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                eventThread.postEvent((Set)entry.getKey(), (EventDispatcher)entry.getValue(), eventAction, eventObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventSynchronous(int eventAction, Object eventObject) {
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.readOnly = true;
        }
        Iterator iter = this.queue.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            EventManager.dispatchEvent((Set)entry.getKey(), (EventDispatcher)entry.getValue(), eventAction, eventObject);
        }
    }
}

