/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceSaveableComparison;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.texteditor.ITextEditor;

public class SaveablesCompareEditorInput
extends CompareEditorInput
implements ISaveablesSource {
    private IPropertyListener fLeftPropertyListener;
    private IPropertyListener fRightPropertyListener;
    private Saveable fLeftSaveable;
    private Saveable fRightSaveable;
    private ITypedElement fAncestorElement;
    private ITypedElement fLeftElement;
    private ITypedElement fRightElement;
    private final IWorkbenchPage page;
    private final ListenerList inputChangeListeners = new ListenerList(1);
    private ICompareInputChangeListener compareInputChangeListener;
    private CompareInputChangeNotifier notifier = new CompareInputChangeNotifier(){

        protected IResource[] getResources(ICompareInput input) {
            IResource leftResource = SaveablesCompareEditorInput.this.getResource(SaveablesCompareEditorInput.this.fLeftElement);
            IResource rightResource = SaveablesCompareEditorInput.this.getResource(SaveablesCompareEditorInput.this.fRightElement);
            if (leftResource == null && rightResource == null) {
                return new IResource[0];
            }
            if (leftResource == null && rightResource != null) {
                return new IResource[]{rightResource};
            }
            if (leftResource != null && rightResource == null) {
                return new IResource[]{leftResource};
            }
            return new IResource[]{leftResource, rightResource};
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SaveablesCompareEditorInput(ITypedElement ancestor, ITypedElement left, ITypedElement right, IWorkbenchPage page) {
        super(new CompareConfiguration());
        this.page = page;
        this.fAncestorElement = ancestor;
        this.fLeftElement = left;
        this.fRightElement = right;
    }

    private static ITypedElement getFileElement(ITypedElement element, CompareEditorInput editorInput) {
        if (element instanceof LocalResourceTypedElement) {
            return element;
        }
        if (editorInput instanceof CompareFileRevisionEditorInput) {
            return ((CompareFileRevisionEditorInput)editorInput).getLocalElement();
        }
        return null;
    }

    public static ITypedElement createFileElement(IFile file) {
        return new LocalResourceTypedElement((IResource)file);
    }

    private ISaveablesLifecycleListener getSaveablesLifecycleListener(IWorkbenchPart part) {
        ISaveablesLifecycleListener listener;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((listener = (ISaveablesLifecycleListener)Utils.getAdapter(part, clazz)) == null) {
            IWorkbenchPartSite iWorkbenchPartSite = part.getSite();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            listener = (ISaveablesLifecycleListener)iWorkbenchPartSite.getService((Class)clazz2);
        }
        return listener;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.compareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                if (source == SaveablesCompareEditorInput.this.getCompareResult()) {
                    boolean closed = false;
                    if (source.getKind() == 0) {
                        closed = SaveablesCompareEditorInput.this.closeEditor(true);
                    }
                    if (!closed) {
                        SaveablesCompareEditorInput.this.propogateInputChange();
                    }
                }
            }
        };
        this.getCompareInput().addCompareInputChangeListener(this.compareInputChangeListener);
        if (this.getLeftSaveable() instanceof SaveableComparison) {
            SaveableComparison lscm = (SaveableComparison)this.fLeftSaveable;
            this.fLeftPropertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        SaveablesCompareEditorInput.this.setDirty(SaveablesCompareEditorInput.this.fLeftSaveable.isDirty());
                    }
                }
            };
            lscm.addPropertyListener(this.fLeftPropertyListener);
        }
        if (this.getRightSaveable() instanceof SaveableComparison) {
            SaveableComparison rscm = (SaveableComparison)this.fRightSaveable;
            this.fRightPropertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        SaveablesCompareEditorInput.this.setDirty(SaveablesCompareEditorInput.this.fRightSaveable.isDirty());
                    }
                }
            };
            rscm.addPropertyListener(this.fRightPropertyListener);
        }
        this.setDirty(this.fLeftSaveable.isDirty() || this.fRightSaveable.isDirty());
    }

    protected void handleDispose() {
        LocalResourceSaveableComparison rsc;
        SaveableComparison scm;
        super.handleDispose();
        ICompareInput compareInput = this.getCompareInput();
        if (compareInput != null) {
            compareInput.removeCompareInputChangeListener(this.compareInputChangeListener);
        }
        this.compareInputChangeListener = null;
        if (this.fLeftSaveable instanceof SaveableComparison) {
            scm = (SaveableComparison)this.fLeftSaveable;
            scm.removePropertyListener(this.fLeftPropertyListener);
        }
        if (this.fLeftSaveable instanceof LocalResourceSaveableComparison) {
            rsc = (LocalResourceSaveableComparison)this.fLeftSaveable;
            rsc.dispose();
        }
        if (this.fRightSaveable instanceof SaveableComparison) {
            scm = (SaveableComparison)this.fRightSaveable;
            scm.removePropertyListener(this.fRightPropertyListener);
        }
        if (this.fRightSaveable instanceof LocalResourceSaveableComparison) {
            rsc = (LocalResourceSaveableComparison)this.fRightSaveable;
            rsc.dispose();
        }
        if (this.getCompareResult() instanceof IDisposable) {
            ((IDisposable)this.getCompareResult()).dispose();
        }
    }

    private String[] getLabels() {
        IResource leftResource = this.getResource(this.fLeftElement);
        IResource rightResource = this.getResource(this.fRightElement);
        if (leftResource != null && rightResource != null) {
            IResource ancestorResource;
            String leftLabel = leftResource.getFullPath().makeRelative().toString();
            String rightLabel = rightResource.getFullPath().makeRelative().toString();
            if (this.fAncestorElement != null && (ancestorResource = this.getResource(this.fAncestorElement)) != null) {
                String ancestorLabel = rightResource.getFullPath().makeRelative().toString();
                return new String[]{ancestorLabel, leftLabel, rightLabel};
            }
            return new String[]{leftLabel, rightLabel};
        }
        if (this.fAncestorElement != null) {
            return new String[]{this.fAncestorElement.getName(), this.fLeftElement.getName(), this.fRightElement.getName()};
        }
        return new String[]{this.fLeftElement.getName(), this.fRightElement.getName()};
    }

    public String getToolTipText() {
        Object[] labels = this.getLabels();
        if (labels.length == 3) {
            return NLS.bind((String)TeamUIMessages.SaveablesCompareEditorInput_threeWayTooltip, (Object[])labels);
        }
        return NLS.bind((String)TeamUIMessages.SaveablesCompareEditorInput_twoWayTooltip, (Object[])labels);
    }

    public String getTitle() {
        Object[] labels = this.getLabels();
        if (labels.length == 3) {
            return NLS.bind((String)TeamUIMessages.SaveablesCompareEditorInput_threeWayTitle, (Object[])labels);
        }
        return NLS.bind((String)TeamUIMessages.SaveablesCompareEditorInput_twoWayTitle, (Object[])labels);
    }

    private IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    protected final ICompareInput getCompareInput() {
        return (ICompareInput)this.getCompareResult();
    }

    protected void fireInputChange() {
        ((MyDiffNode)this.getCompareResult()).fireChange();
    }

    protected Saveable getLeftSaveable() {
        if (this.fLeftSaveable == null) {
            this.fLeftSaveable = this.createLeftSaveable();
        }
        return this.fLeftSaveable;
    }

    protected Saveable getRightSaveable() {
        if (this.fRightSaveable == null) {
            this.fRightSaveable = this.createRightSaveable();
        }
        return this.fRightSaveable;
    }

    protected Saveable createLeftSaveable() {
        Object compareResult = this.getCompareResult();
        Assert.isNotNull((Object)compareResult, (String)"This method cannot be called until after prepareInput is called");
        ITypedElement leftFileElement = SaveablesCompareEditorInput.getFileElement(this.getCompareInput().getLeft(), this);
        return new InternalResourceSaveableComparison((ICompareInput)compareResult, this, leftFileElement);
    }

    protected Saveable createRightSaveable() {
        Object compareResult = this.getCompareResult();
        Assert.isNotNull((Object)compareResult, (String)"This method cannot be called until after prepareInput is called");
        ITypedElement rightFileElement = SaveablesCompareEditorInput.getFileElement(this.getCompareInput().getRight(), this);
        return new InternalResourceSaveableComparison((ICompareInput)compareResult, this, rightFileElement);
    }

    public Saveable[] getActiveSaveables() {
        if (this.getCompareResult() == null) {
            return new Saveable[0];
        }
        return new Saveable[]{this.getLeftSaveable(), this.getRightSaveable()};
    }

    public Saveable[] getSaveables() {
        return this.getActiveSaveables();
    }

    public Viewer findContentViewer(Viewer pOldViewer, ICompareInput pInput, Composite pParent) {
        boolean isNewViewer;
        Viewer newViewer = super.findContentViewer(pOldViewer, pInput, pParent);
        boolean bl = isNewViewer = newViewer != pOldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier && this.fLeftSaveable instanceof IPropertyChangeListener && this.fRightSaveable instanceof IPropertyChangeListener) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            final IPropertyChangeListener lpcl = (IPropertyChangeListener)this.fLeftSaveable;
            final IPropertyChangeListener rpcl = (IPropertyChangeListener)this.fRightSaveable;
            dsp.addPropertyChangeListener(lpcl);
            dsp.addPropertyChangeListener(rpcl);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(lpcl);
                    dsp.removePropertyChangeListener(rpcl);
                }
            });
        }
        return newViewer;
    }

    public boolean isDirty() {
        if (this.fLeftSaveable != null && this.fLeftSaveable.isDirty()) {
            return true;
        }
        if (this.fRightSaveable != null && this.fRightSaveable.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                IEditorPart part = SaveablesCompareEditorInput.this.getPage().findEditor((IEditorInput)SaveablesCompareEditorInput.this);
                SaveablesCompareEditorInput.this.getPage().closeEditor(part, false);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display display = this.getPage().getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.prepareCompareInput(monitor);
        if (input != null) {
            this.setTitle(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object[])new String[]{input.getName()}));
        }
        return input;
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.createCompareInput();
        this.getCompareConfiguration().setLeftEditable(this.isEditable(input.getLeft()));
        this.getCompareConfiguration().setRightEditable(this.isEditable(input.getRight()));
        this.initLabels();
        return input;
    }

    private boolean isEditable(Object obj) {
        if (obj instanceof IEditableContent) {
            return ((IEditableContent)obj).isEditable();
        }
        return false;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        IResource ancestorResource = this.getResource(this.fAncestorElement);
        IResource leftResource = this.getResource(this.fLeftElement);
        IResource rightResource = this.getResource(this.fRightElement);
        if (ancestorResource != null) {
            String ancestorLabel = ancestorResource.getFullPath().makeRelative().toString();
            cc.setAncestorLabel(ancestorLabel);
        }
        if (leftResource != null && rightResource != null) {
            String leftLabel = leftResource.getFullPath().makeRelative().toString();
            String rightLabel = rightResource.getFullPath().makeRelative().toString();
            cc.setLeftLabel(leftLabel);
            cc.setRightLabel(rightLabel);
        }
    }

    private ICompareInput createCompareInput() {
        return this.fAncestorElement == null ? new MyDiffNode(this.fLeftElement, this.fRightElement) : new MyDiffNode(this.fAncestorElement, this.fLeftElement, this.fRightElement);
    }

    private IResource getResource(ITypedElement pElement) {
        if (pElement instanceof LocalResourceTypedElement && pElement instanceof IResourceProvider) {
            return ((IResourceProvider)pElement).getResource();
        }
        return null;
    }

    public void registerContextMenu(MenuManager pMenuManager, final ISelectionProvider pSelectionProvider) {
        super.registerContextMenu(pMenuManager, pSelectionProvider);
        final Saveable lLeftSaveable = this.getLeftSaveable();
        final ITypedElement lLeftElement = SaveablesCompareEditorInput.getFileElement(this.getCompareInput().getLeft(), this);
        if (lLeftSaveable instanceof LocalResourceSaveableComparison) {
            pMenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    SaveablesCompareEditorInput.handleMenuAboutToShow(manager, SaveablesCompareEditorInput.this.getContainer(), lLeftSaveable, lLeftElement, pSelectionProvider);
                }
            });
        }
        final Saveable lRightSaveable = this.getRightSaveable();
        final ITypedElement lRightElement = SaveablesCompareEditorInput.getFileElement(this.getCompareInput().getRight(), this);
        if (lRightSaveable instanceof LocalResourceSaveableComparison) {
            pMenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    SaveablesCompareEditorInput.handleMenuAboutToShow(manager, SaveablesCompareEditorInput.this.getContainer(), lRightSaveable, lRightElement, pSelectionProvider);
                }
            });
        }
    }

    public void addCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.add((Object)listener);
        } else {
            super.addCompareInputChangeListener(input, listener);
        }
    }

    public void removeCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.remove((Object)listener);
        } else {
            super.removeCompareInputChangeListener(input, listener);
        }
    }

    private void propogateInputChange() {
        if (!this.inputChangeListeners.isEmpty()) {
            Object[] allListeners = this.inputChangeListeners.getListeners();
            final ICompareInput compareResult = (ICompareInput)this.getCompareResult();
            int i = 0;
            while (i < allListeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)allListeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged(compareResult);
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++i;
            }
        }
    }

    public Image getTitleImage() {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        Image image = reg.get("eview16/synch_synch.gif");
        if (image == null) {
            image = this.getImageDescriptor().createImage();
            reg.put("eview16/synch_synch.gif", image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor() {
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.gif");
    }

    public boolean canRunAsJob() {
        return true;
    }

    private static String getShowInMenuLabel() {
        IBindingService bindingService;
        String keyBinding = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)TeamUIMessages.SaveableCompareEditorInput_0, (Object)keyBinding);
    }

    public static void handleMenuAboutToShow(IMenuManager manager, ICompareContainer container, Saveable saveable, ITypedElement element, ISelectionProvider provider) {
        if (provider instanceof ITextViewer) {
            IDocument other;
            ITextViewer v = (ITextViewer)provider;
            IDocument d = v.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (d == (other = (IDocument)Utils.getAdapter(saveable, clazz)) && element instanceof IResourceProvider) {
                IResourceProvider rp = (IResourceProvider)element;
                IResource resource = rp.getResource();
                StructuredSelection selection = new StructuredSelection((Object)resource);
                IWorkbenchPart workbenchPart = container.getWorkbenchPart();
                if (workbenchPart != null) {
                    IWorkbenchPartSite ws = workbenchPart.getSite();
                    MenuManager submenu1 = new MenuManager(SaveablesCompareEditorInput.getShowInMenuLabel());
                    IContributionItem showInMenu = ContributionItemFactory.VIEWS_SHOW_IN.create(ws.getWorkbenchWindow());
                    submenu1.add(showInMenu);
                    manager.insertAfter("file", (IContributionItem)submenu1);
                    MenuManager submenu2 = new MenuManager(TeamUIMessages.OpenWithActionGroup_0);
                    submenu2.add((IContributionItem)new OpenWithMenu(ws.getPage(), (IAdaptable)resource, (IWorkbenchSite)ws, v){
                        private final /* synthetic */ IWorkbenchSite val$ws;
                        private final /* synthetic */ ITextViewer val$v;
                        {
                            this.val$ws = iWorkbenchSite;
                            this.val$v = iTextViewer;
                        }

                        protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                            super.openEditor(editorDescriptor, openUsingDescriptor);
                            IEditorPart editor = this.val$ws.getPage().getActiveEditor();
                            Point selectedRange = this.val$v.getSelectedRange();
                            SaveablesCompareEditorInput.revealInEditor(editor, selectedRange.x, selectedRange.y);
                        }
                    });
                    manager.insertAfter("file", (IContributionItem)submenu2);
                    OpenFileAction openFileAction = new OpenFileAction(ws.getPage(), (IWorkbenchSite)ws, v){
                        private final /* synthetic */ IWorkbenchSite val$ws;
                        private final /* synthetic */ ITextViewer val$v;
                        {
                            this.val$ws = iWorkbenchSite;
                            this.val$v = iTextViewer;
                        }

                        public void run() {
                            super.run();
                            IEditorPart editor = this.val$ws.getPage().getActiveEditor();
                            Point selectedRange = this.val$v.getSelectedRange();
                            SaveablesCompareEditorInput.revealInEditor(editor, selectedRange.x, selectedRange.y);
                        }
                    };
                    openFileAction.selectionChanged((IStructuredSelection)selection);
                    manager.insertAfter("file", (IAction)openFileAction);
                }
            }
        }
    }

    private static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        IGotoMarker iGotoMarker;
        IGotoMarker gotoMarkerTarget;
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            gotoMarkerTarget = (IGotoMarker)editor;
        } else if (editor != null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iGotoMarker = (IGotoMarker)editor.getAdapter((Class)clazz);
        } else {
            iGotoMarker = gotoMarkerTarget = null;
        }
        if (gotoMarkerTarget != null) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
    }

    private class InternalResourceSaveableComparison
    extends LocalResourceSaveableComparison
    implements EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
        private LocalResourceTypedElement lrte;
        private boolean connected = false;

        public InternalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput, ITypedElement element) {
            super(input, editorInput, element);
            if (element instanceof LocalResourceTypedElement) {
                this.lrte = (LocalResourceTypedElement)element;
                if (this.lrte.isConnected()) {
                    this.registerSaveable(true);
                } else {
                    this.lrte.setSharedDocumentListener(this);
                }
            }
        }

        protected void fireInputChange() {
            SaveablesCompareEditorInput.this.fireInputChange();
        }

        public void dispose() {
            super.dispose();
            if (this.lrte != null) {
                this.lrte.setSharedDocumentListener(null);
            }
        }

        public void handleDocumentConnected() {
            if (this.connected) {
                return;
            }
            this.connected = true;
            this.registerSaveable(false);
            if (this.lrte != null) {
                this.lrte.setSharedDocumentListener(null);
            }
        }

        private void registerSaveable(boolean init) {
            ICompareContainer container = SaveablesCompareEditorInput.this.getContainer();
            IWorkbenchPart part = container.getWorkbenchPart();
            if (part != null) {
                ISaveablesLifecycleListener lifecycleListener = SaveablesCompareEditorInput.this.getSaveablesLifecycleListener(part);
                if (!init) {
                    lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 3, new Saveable[]{this}, false));
                }
                this.initializeHashing();
                lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 1, new Saveable[]{this}, false));
            }
        }

        public void handleDocumentDeleted() {
        }

        public void handleDocumentDisconnected() {
        }

        public void handleDocumentFlushed() {
        }

        public void handleDocumentSaved() {
        }

        public boolean equals(Object obj) {
            Object document;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Saveable)) {
                return false;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((document = this.getAdapter(clazz)) != null) {
                Saveable saveable = (Saveable)obj;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object otherDocument = saveable.getAdapter((Class)clazz2);
                return document.equals(otherDocument);
            }
            if (obj instanceof InternalResourceSaveableComparison) {
                InternalResourceSaveableComparison rscm = (InternalResourceSaveableComparison)obj;
                return rscm.getInput().equals(this.getInput()) && rscm.lrte.equals((Object)this.lrte);
            }
            return false;
        }
    }

    private class MyDiffNode
    extends AbstractCompareInput {
        public MyDiffNode(ITypedElement left, ITypedElement right) {
            super(3, null, left, right);
        }

        public MyDiffNode(ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(12, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
        }

        protected CompareInputChangeNotifier getChangeNotifier() {
            return SaveablesCompareEditorInput.this.notifier;
        }

        public boolean needsUpdate() {
            return true;
        }

        public void update() {
            this.fireChange();
        }
    }
}

