/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureEntry;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DataDetailsSection
extends PDESection
implements IFormPart,
IPartSelectionListener {
    protected IFeatureEntry fInput;
    private FormEntry fdownloadSizeText;
    private FormEntry fInstallSizeText;

    public DataDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.SiteEditor_DataDetailsSection_title, PDEUIMessages.SiteEditor_DataDetailsSection_desc, 0);
    }

    public DataDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void cancelEdit() {
        this.fdownloadSizeText.cancelEdit();
        this.fInstallSizeText.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.fdownloadSizeText.commit();
        this.fInstallSizeText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(1808));
        this.fdownloadSizeText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_DataDetailsSection_downloadSize, null, false);
        this.fdownloadSizeText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                if (DataDetailsSection.this.fInput != null) {
                    try {
                        DataDetailsSection.this.fInput.setDownloadSize(DataDetailsSection.this.getLong(text.getValue()));
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fdownloadSizeText);
        this.fdownloadSizeText.setEditable(this.isEditable());
        this.fInstallSizeText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_DataDetailsSection_installSize, null, false);
        this.fInstallSizeText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                if (DataDetailsSection.this.fInput != null) {
                    try {
                        DataDetailsSection.this.fInput.setInstallSize(DataDetailsSection.this.getLong(text.getValue()));
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fInstallSizeText);
        this.fInstallSizeText.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(IManagedForm form) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.initialize(form);
    }

    protected void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 3 && e.getChangedObjects().length > 0 && e.getChangedObjects()[0] instanceof IFeatureData && e.getChangedObjects()[0] == this.fInput) {
            this.markStale();
        }
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fInput = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFeatureData ? (IFeatureData)o : null) : null;
        this.update();
    }

    public void setFocus() {
        if (this.fdownloadSizeText != null) {
            this.fdownloadSizeText.getText().setFocus();
        }
    }

    private void update() {
        if (this.fInput != null) {
            this.fdownloadSizeText.setValue(this.fInput.getDownloadSize() >= 0L ? "" + this.fInput.getDownloadSize() : null, true);
            this.fInstallSizeText.setValue(this.fInput.getInstallSize() >= 0L ? "" + this.fInput.getInstallSize() : null, true);
        } else {
            this.fdownloadSizeText.setValue(null, true);
            this.fInstallSizeText.setValue(null, true);
        }
        this.fdownloadSizeText.setEditable(this.fInput != null && this.isEditable());
        this.fInstallSizeText.setEditable(this.fInput != null && this.isEditable());
    }

    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    private long getLong(String svalue) {
        if (svalue == null) {
            return 0L;
        }
        try {
            return Long.parseLong(svalue);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

