/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImagesOnFileSystemRegistry {
    private static final String IMAGE_DIR = "jdt-images";
    private HashMap fURLMap = new HashMap();
    private final File fTempDir = this.getTempDir();
    private final JavaElementImageProvider fImageProvider = new JavaElementImageProvider();
    private int fImageCount = 0;

    private File getTempDir() {
        File imageDir;
        block5: {
            try {
                imageDir = JavaPlugin.getDefault().getStateLocation().append(IMAGE_DIR).toFile();
                if (imageDir.exists()) {
                    this.delete(imageDir);
                }
                if (!imageDir.exists()) {
                    imageDir.mkdir();
                }
                if (imageDir.isDirectory()) break block5;
                JavaPlugin.logErrorMessage("Failed to create image directory " + imageDir.toString());
                return null;
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return imageDir;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            int i = 0;
            while (i < listFiles.length) {
                this.delete(listFiles[i]);
                ++i;
            }
        }
        file.delete();
    }

    public URL getImageURL(IJavaElement element) {
        ImageDescriptor descriptor = this.fImageProvider.getJavaImageDescriptor(element, 3);
        if (descriptor == null) {
            return null;
        }
        return this.getImageURL(descriptor);
    }

    public URL getImageURL(ImageDescriptor descriptor) {
        if (this.fTempDir == null) {
            return null;
        }
        URL url = (URL)this.fURLMap.get(descriptor);
        if (url != null) {
            return url;
        }
        File imageFile = this.getNewFile();
        ImageData imageData = descriptor.getImageData();
        if (imageData == null) {
            return null;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        loader.save(imageFile.getAbsolutePath(), 5);
        try {
            url = imageFile.toURI().toURL();
            this.fURLMap.put(descriptor, url);
            return url;
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private File getNewFile() {
        File file;
        while ((file = new File(this.fTempDir, String.valueOf(String.valueOf(this.getImageCount())) + ".png")).exists()) {
        }
        return file;
    }

    private synchronized int getImageCount() {
        return this.fImageCount++;
    }

    public void dispose() {
        if (this.fTempDir != null) {
            this.delete(this.fTempDir);
        }
        this.fURLMap = null;
    }
}

