/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.features;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SiteFeature {
    private URL base;
    private List categoryNames;
    private String featureId;
    private String featureVersion;
    private final boolean resolved = false;
    private URL url;
    private String urlString;

    public static boolean sameURL(URL url1, URL url2) {
        if (url1 == url2) {
            return true;
        }
        if (url1 == null ^ url2 == null) {
            return false;
        }
        boolean isFile1 = "file".equalsIgnoreCase(url1.getProtocol());
        boolean isFile2 = "file".equalsIgnoreCase(url2.getProtocol());
        if (isFile1 && isFile2) {
            File file1 = new File(url1.getFile());
            File file2 = new File(url2.getFile());
            return file1.equals(file2);
        }
        if (isFile1 ^ isFile2) {
            return false;
        }
        return SiteFeature.getExternalForm(url1).equals(SiteFeature.getExternalForm(url2));
    }

    private static String getExternalForm(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm == null) {
            return "";
        }
        if ((externalForm = externalForm.trim()).endsWith("/")) {
            externalForm = externalForm.substring(0, externalForm.length() - 1);
        }
        return externalForm.toLowerCase();
    }

    public void addCategoryName(String categoryName) {
        if (this.categoryNames == null) {
            this.categoryNames = new ArrayList();
        }
        if (!this.categoryNames.contains(categoryName)) {
            this.categoryNames.add(categoryName);
        }
    }

    private void delayedResolve() {
        try {
            this.url = new URL(this.base, this.urlString);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SiteFeature)) {
            return false;
        }
        SiteFeature that = (SiteFeature)object;
        if (this.featureId == null ? that.featureId != null : !this.featureId.equals(that.featureId)) {
            return false;
        }
        if (this.featureVersion == null ? that.featureVersion != null : !this.featureVersion.equals(that.featureVersion)) {
            return false;
        }
        return SiteFeature.sameURL(this.getURL(), that.getURL());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.featureId == null ? 0 : this.featureId.hashCode());
        result = 31 * result + (this.featureVersion == null ? 0 : this.featureVersion.hashCode());
        if (this.getURL() == null) {
            return result;
        }
        if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
            File f = new File(this.getURL().getFile());
            result = 31 * result + f.hashCode();
        } else {
            result = 31 * result + SiteFeature.getExternalForm(this.getURL()).hashCode();
        }
        return result;
    }

    public String[] getCategoryNames() {
        if (this.categoryNames == null) {
            return new String[0];
        }
        return this.categoryNames.toArray(new String[0]);
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public void setFeatureIdentifier(String featureId) {
        this.featureId = featureId;
    }

    public void setFeatureVersion(String featureVersion) {
        this.featureVersion = featureVersion;
    }

    public void setURLString(String urlString) {
        this.urlString = urlString;
        this.url = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getClass().toString()) + " :");
        buffer.append(" at ");
        if (this.url != null) {
            buffer.append(this.url.toExternalForm());
        }
        return buffer.toString();
    }
}

