/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.typehierarchy.MethodsViewer;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;

public class MethodsLabelProvider
extends AppearanceAwareLabelProvider {
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;
    private MethodsViewer fMethodsViewer;
    private IPropertyChangeListener fColorRegistryListener;

    public MethodsLabelProvider(TypeHierarchyLifeCycle lifeCycle, MethodsViewer methodsViewer) {
        super(36283885813801L, 1);
        this.fHierarchy = lifeCycle;
        this.fShowDefiningType = false;
        this.fMethodsViewer = methodsViewer;
        this.fColorRegistryListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jdt.ui.ColoredLabels.inherited")) {
                    MethodsLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)MethodsLabelProvider.this, null));
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(this.fColorRegistryListener);
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private IType getDefiningType(Object element) throws JavaModelException {
        int kind = ((IJavaElement)element).getElementType();
        if (kind != 9 && kind != 8 && kind != 10) {
            return null;
        }
        IType declaringType = ((IMember)element).getDeclaringType();
        if (kind != 9) {
            return declaringType;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return declaringType;
        }
        MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
        IMethod method = (IMethod)element;
        IMethod res = tester.findDeclaringMethod(method, true);
        if (res == null || method.equals(res)) {
            return declaringType;
        }
        return res.getDeclaringType();
    }

    public String getText(Object element) {
        String text = super.getText(element);
        String qualifier = this.getQualifier(element);
        if (qualifier != null) {
            return String.valueOf(qualifier) + text;
        }
        return text;
    }

    public StyledString getStyledText(Object element) {
        StyledString text = super.getStyledText(element);
        String qualifier = this.getQualifier(element);
        if (qualifier != null) {
            StyledString styledString = new StyledString(qualifier);
            styledString.append(text);
            return styledString;
        }
        return text;
    }

    private String getQualifier(Object element) {
        if (this.fShowDefiningType) {
            try {
                IType type = this.getDefiningType(element);
                if (type != null) {
                    return String.valueOf(super.getText(type)) + JavaElementLabels.CONCAT_STRING;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public Color getForeground(Object element) {
        IMethod curr;
        IType declaringType;
        if (this.fMethodsViewer.isShowInheritedMethods() && element instanceof IMethod && !(declaringType = (curr = (IMethod)element).getDeclaringType()).equals(this.fMethodsViewer.getInput())) {
            return JFaceResources.getColorRegistry().get("org.eclipse.jdt.ui.ColoredLabels.inherited");
        }
        return null;
    }

    public void dispose() {
        JFaceResources.getColorRegistry().removeListener(this.fColorRegistryListener);
        this.fColorRegistryListener = null;
        super.dispose();
    }
}

