/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;

public class FlowContext {
    public static final Enum MERGE = new Enum();
    public static final Enum ARGUMENTS = new Enum();
    public static final Enum RETURN_VALUES = new Enum();
    private int fStart;
    private int fLength;
    private boolean fConsiderAccessMode;
    private boolean fLoopReentranceMode;
    private Enum fComputeMode;
    private IVariableBinding[] fLocals;
    private List fExceptionStack;
    private static final List EMPTY_CATCH_CLAUSE = new ArrayList(0);

    public FlowContext(int start, int length) {
        this.fStart = start;
        this.fLength = length;
        this.fExceptionStack = new ArrayList(3);
    }

    public void setConsiderAccessMode(boolean b) {
        this.fConsiderAccessMode = b;
    }

    public void setComputeMode(Enum mode) {
        this.fComputeMode = mode;
    }

    void setLoopReentranceMode(boolean b) {
        this.fLoopReentranceMode = b;
    }

    int getArrayLength() {
        return this.fLength;
    }

    int getStartingIndex() {
        return this.fStart;
    }

    boolean considerAccessMode() {
        return this.fConsiderAccessMode;
    }

    boolean isLoopReentranceMode() {
        return this.fLoopReentranceMode;
    }

    boolean computeMerge() {
        return this.fComputeMode == MERGE;
    }

    boolean computeArguments() {
        return this.fComputeMode == ARGUMENTS;
    }

    boolean computeReturnValues() {
        return this.fComputeMode == RETURN_VALUES;
    }

    public IVariableBinding getLocalFromId(int id) {
        return this.getLocalFromIndex(id - this.fStart);
    }

    public IVariableBinding getLocalFromIndex(int index) {
        if (this.fLocals == null || index > this.fLocals.length) {
            return null;
        }
        return this.fLocals[index];
    }

    public int getIndexFromLocal(IVariableBinding local) {
        if (this.fLocals == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fLocals.length) {
            if (this.fLocals[i] == local) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void manageLocal(IVariableBinding local) {
        if (this.fLocals == null) {
            this.fLocals = new IVariableBinding[this.fLength];
        }
        this.fLocals[local.getVariableId() - this.fStart] = local;
    }

    void pushExcptions(TryStatement node) {
        List catchClauses = node.catchClauses();
        if (catchClauses == null) {
            catchClauses = EMPTY_CATCH_CLAUSE;
        }
        this.fExceptionStack.add(catchClauses);
    }

    void popExceptions() {
        Assert.isTrue((this.fExceptionStack.size() > 0 ? 1 : 0) != 0);
        this.fExceptionStack.remove(this.fExceptionStack.size() - 1);
    }

    boolean isExceptionCaught(ITypeBinding excpetionType) {
        Iterator exceptions = this.fExceptionStack.iterator();
        while (exceptions.hasNext()) {
            Iterator catchClauses = ((List)exceptions.next()).iterator();
            while (catchClauses.hasNext()) {
                SingleVariableDeclaration catchedException = ((CatchClause)catchClauses.next()).getException();
                IVariableBinding binding = catchedException.resolveBinding();
                if (binding == null) continue;
                ITypeBinding catchedType = binding.getType();
                while (catchedType != null) {
                    if (catchedType == excpetionType) {
                        return true;
                    }
                    catchedType = catchedType.getSuperclass();
                }
            }
        }
        return false;
    }

    private static class Enum {
        private Enum() {
        }
    }
}

