/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class LocalVariableIndex
extends ASTVisitor {
    private int fTopIndex;

    public static int perform(BodyDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        switch (declaration.getNodeType()) {
            case 23: 
            case 28: 
            case 31: {
                return LocalVariableIndex.internalPerform(declaration);
            }
        }
        throw new IllegalArgumentException(declaration.toString());
    }

    private static int internalPerform(BodyDeclaration methodOrInitializer) {
        BodyDeclaration target = methodOrInitializer;
        ASTNode parent = target.getParent();
        while (parent != null) {
            if (parent instanceof MethodDeclaration || parent instanceof Initializer || parent instanceof FieldDeclaration) {
                target = (BodyDeclaration)parent;
            }
            parent = parent.getParent();
        }
        return LocalVariableIndex.doPerform(target);
    }

    private static int doPerform(BodyDeclaration node) {
        LocalVariableIndex counter = new LocalVariableIndex();
        node.accept((ASTVisitor)counter);
        return counter.fTopIndex;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    private void handleVariableBinding(IVariableBinding binding) {
        if (binding == null) {
            return;
        }
        this.fTopIndex = Math.max(this.fTopIndex, binding.getVariableId());
    }
}

