/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;

public abstract class RefactoringHistoryMergeWizard
extends RefactoringHistoryWizard {
    private final Set fAddedFiles = new HashSet();
    private final Set fChangedFiles = new HashSet();
    private final IResourceChangeListener fListener = new WorkspaceChangeListener();
    private final Set fRemovedFiles = new HashSet();

    protected RefactoringHistoryMergeWizard(String caption, String title, String description) {
        super(caption, title, description);
    }

    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        this.fAddedFiles.clear();
        this.fRemovedFiles.clear();
        this.fChangedFiles.clear();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fListener, 1);
        return super.aboutToPerformHistory(monitor);
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)descriptor);
        long stamp = descriptor.getTimeStamp();
        if (stamp >= 0L) {
            RefactoringHistoryService.getInstance().setOverrideTimeStamp(stamp);
        }
        return super.aboutToPerformRefactoring(refactoring, descriptor, monitor);
    }

    public Set getAddedFiles() {
        return this.fAddedFiles;
    }

    public Set getChangedFiles() {
        return this.fChangedFiles;
    }

    public Set getRemovedFiles() {
        return this.fRemovedFiles;
    }

    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fListener);
        RefactoringHistoryService.getInstance().setOverrideTimeStamp(-1L);
        return super.historyPerformed(monitor);
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        RefactoringHistoryService.getInstance().setOverrideTimeStamp(-1L);
        return super.refactoringPerformed(refactoring, monitor);
    }

    public void resolveConflicts(IMergeContext context) {
        IDiff diff;
        IResource resource;
        Assert.isNotNull((Object)context);
        Iterator iterator = this.fChangedFiles.iterator();
        while (iterator.hasNext()) {
            resource = (IResource)iterator.next();
            diff = context.getDiffTree().getDiff(resource);
            if (diff == null) continue;
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        iterator = this.fAddedFiles.iterator();
        while (iterator.hasNext()) {
            resource = (IResource)iterator.next();
            diff = context.getDiffTree().getDiff(resource);
            if (diff == null) continue;
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        iterator = this.fRemovedFiles.iterator();
        while (iterator.hasNext()) {
            resource = (IResource)iterator.next();
            diff = context.getDiffTree().getDiff(resource);
            if (diff == null) continue;
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
    }

    static /* synthetic */ Set access$0(RefactoringHistoryMergeWizard refactoringHistoryMergeWizard) {
        return refactoringHistoryMergeWizard.fAddedFiles;
    }

    static /* synthetic */ Set access$1(RefactoringHistoryMergeWizard refactoringHistoryMergeWizard) {
        return refactoringHistoryMergeWizard.fRemovedFiles;
    }

    static /* synthetic */ Set access$2(RefactoringHistoryMergeWizard refactoringHistoryMergeWizard) {
        return refactoringHistoryMergeWizard.fChangedFiles;
    }

    private class WorkspaceChangeListener
    implements IResourceChangeListener {
        private WorkspaceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                try {
                    delta.accept(new IResourceDeltaVisitor(this, delta){
                        final /* synthetic */ WorkspaceChangeListener this$1;
                        private final /* synthetic */ IResourceDelta val$delta;
                        {
                            this.this$1 = workspaceChangeListener;
                            this.val$delta = iResourceDelta;
                        }

                        public final boolean visit(IResourceDelta current) throws CoreException {
                            IResource resource = current.getResource();
                            if (!resource.isDerived() && resource.getType() == 1) {
                                switch (this.val$delta.getKind()) {
                                    case 1: {
                                        RefactoringHistoryMergeWizard.access$0(WorkspaceChangeListener.access$1(this.this$1)).add(resource);
                                        break;
                                    }
                                    case 2: {
                                        RefactoringHistoryMergeWizard.access$1(WorkspaceChangeListener.access$1(this.this$1)).add(resource);
                                        break;
                                    }
                                    case 4: {
                                        RefactoringHistoryMergeWizard.access$2(WorkspaceChangeListener.access$1(this.this$1)).add(resource);
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException exception) {
                    RefactoringUIPlugin.log(exception);
                }
            }
        }

        static /* synthetic */ RefactoringHistoryMergeWizard access$1(WorkspaceChangeListener workspaceChangeListener) {
            return workspaceChangeListener.RefactoringHistoryMergeWizard.this;
        }
    }
}

