/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;

public class IndexedValuePartition
implements IIndexedValue {
    private int fOffset;
    private int fLength;
    private IIndexedValue fValue;

    public IndexedValuePartition(IIndexedValue value, int offset, int length) {
        this.fValue = value;
        this.fOffset = offset;
        this.fLength = length;
    }

    public int getSize() {
        return this.fLength;
    }

    public IVariable getVariable(int offset) throws DebugException {
        return this.fValue.getVariable(offset);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fValue.getReferenceTypeName();
    }

    public String getValueString() {
        return "";
    }

    public IVariable[] getVariables() throws DebugException {
        return this.getVariables(this.fOffset, this.fLength);
    }

    public boolean hasVariables() {
        return this.fLength > 0;
    }

    public boolean isAllocated() throws DebugException {
        return this.fValue.isAllocated();
    }

    public IDebugTarget getDebugTarget() {
        return this.fValue.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fValue.getLaunch();
    }

    public String getModelIdentifier() {
        return this.fValue.getModelIdentifier();
    }

    public Object getAdapter(Class adapter) {
        return this.fValue.getAdapter(adapter);
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        return this.fValue.getVariables(offset, length);
    }

    public int getInitialOffset() {
        return this.fOffset;
    }
}

