/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.PrintTableRenderingAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AsyncPrintTableRenderingAction
extends PrintTableRenderingAction {
    public AsyncPrintTableRenderingAction(AbstractBaseTableRendering rendering, StructuredViewer viewer) {
        super(rendering, viewer);
    }

    protected void printTable(TableItem[] itemList, GC printGC, Printer printer) {
        Table table = null;
        if (itemList.length > 0) {
            table = itemList[0].getParent();
            int topIndex = table.getTopIndex();
            int itemCount = table.getItemCount();
            int numVisibleLines = Math.min(table.getBounds().height / table.getItemHeight() + 2, itemCount - topIndex);
            ArrayList<TableItem> items = new ArrayList<TableItem>();
            int i = topIndex;
            while (i < topIndex + numVisibleLines) {
                if (itemList[i].getData() == null) break;
                items.add(itemList[i]);
                ++i;
            }
            super.printTable(items.toArray(new TableItem[items.size()]), printGC, printer);
        }
    }
}

