/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.ICompareNavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.ExpandAllAction;
import org.eclipse.team.internal.ui.synchronize.actions.NavigateAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;

public class NavigationActionGroup
extends SynchronizePageActionGroup {
    private ExpandAllAction expandAllAction;
    private Action collapseAll;
    private NavigateAction gotoNext;
    private NavigateAction gotoPrevious;

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        final Viewer viewer = configuration.getPage().getViewer();
        if (viewer instanceof AbstractTreeViewer) {
            this.expandAllAction = new ExpandAllAction((AbstractTreeViewer)viewer);
            Utils.initAction((IAction)this.expandAllAction, "action.expandAll.");
            this.collapseAll = new Action(){

                public void run() {
                    if (viewer.getControl().isDisposed() || !(viewer instanceof AbstractTreeViewer)) {
                        return;
                    }
                    viewer.getControl().setRedraw(false);
                    ((AbstractTreeViewer)viewer).collapseToLevel(viewer.getInput(), -1);
                    viewer.getControl().setRedraw(true);
                }
            };
            Utils.initAction((IAction)this.collapseAll, "action.collapseAll.");
            ICompareNavigator nav = (ICompareNavigator)configuration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
            if (nav != null) {
                this.gotoNext = new NavigateAction(configuration, true);
                this.gotoPrevious = new NavigateAction(configuration, false);
            }
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.expandAllAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager manager = actionBars.getToolBarManager();
        this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.collapseAll);
        if (this.gotoNext != null) {
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.gotoNext);
        }
        if (this.gotoPrevious != null) {
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.gotoPrevious);
        }
    }
}

