/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public final class RenameProjectChange
extends Change {
    private final String fComment;
    private final RefactoringDescriptor fDescriptor;
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    private RenameProjectChange(RefactoringDescriptor descriptor, IPath resourcePath, String newName, String comment, long stampToRestore) {
        this.fDescriptor = descriptor;
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
        this.fComment = comment;
        this.fStampToRestore = stampToRestore;
    }

    public RenameProjectChange(RefactoringDescriptor descriptor, IResource resource, String newName, String comment) {
        this(descriptor, resource.getFullPath(), newName, comment, -1L);
    }

    public ChangeDescriptor getDescriptor() {
        if (this.fDescriptor != null) {
            return new RefactoringChangeDescriptor(this.fDescriptor);
        }
        return null;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public String getName() {
        return MessageFormat.format((String)PDEUIMessages.RenameProjectChange_name, (Object[])new String[]{this.fResourcePath.lastSegment(), this.fNewName});
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format((String)PDEUIMessages.RenameProjectChange_projectDoesNotExist, (Object[])new String[]{this.fResourcePath.toString()}));
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNewName).exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format((String)PDEUIMessages.RenameProjectChange_destinationExists, (Object[])new String[]{this.fNewName}));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(PDEUIMessages.RenameProjectChange_taskTitle, 1);
            IResource resource = this.getResource();
            long currentStamp = resource.getModificationStamp();
            IPath newPath = RenameProjectChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            resource.move(newPath, 32, pm);
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            String oldName = this.fResourcePath.lastSegment();
            RenameProjectChange renameProjectChange = new RenameProjectChange(null, newPath, oldName, this.fComment, currentStamp);
            return renameProjectChange;
        }
        finally {
            pm.done();
        }
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }
}

