/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.ComboSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.PullPushCheckboxTableViewer;
import org.eclipse.jdt.internal.ui.refactoring.PullUpMemberPage;
import org.eclipse.jdt.internal.ui.refactoring.PullUpMethodPage;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class PullUpMemberPage
extends UserInputWizardPage {
    private static final int ACTION_COLUMN = 1;
    private static final String ACTION_PROPERTY = "action";
    protected static final int DECLARE_ABSTRACT_ACTION = 1;
    private static final int MEMBER_COLUMN = 0;
    private static final String MEMBER_PROPERTY = "member";
    protected static final int PULL_UP_ACTION = 0;
    private static final String SETTING_INSTANCEOF = "InstanceOf";
    private static final String SETTING_REPLACE = "Replace";
    private Button fAddButton;
    protected IType[] fCandidateTypes = new IType[0];
    private Button fCreateStubsButton;
    private Button fDeselectAllButton;
    private Button fEditButton;
    private Button fInstanceofButton;
    private Label fLabel;
    private Button fReplaceButton;
    private Button fSelectAllButton;
    private Label fStatusLine;
    protected final PullUpMethodPage fSuccessorPage;
    private Combo fSuperTypesCombo;
    private CheckboxTableViewer fTableViewer;
    protected final String[] METHOD_LABELS;
    protected final String[] TYPE_LABELS;
    private final PullUpRefactoringProcessor fProcessor;

    private static int getEditableCount(MemberActionInfo[] infos) {
        int result = 0;
        int i = 0;
        while (i < infos.length) {
            MemberActionInfo info = infos[i];
            if (info.isEditable()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private static void putToStringMapping(Map result, String[] actionLabels, int actionIndex) {
        result.put(actionLabels[actionIndex], new Integer(actionIndex));
    }

    private static void setActionForInfos(MemberActionInfo[] infos, int action) {
        int i = 0;
        while (i < infos.length) {
            infos[i].setAction(action);
            ++i;
        }
    }

    public PullUpMemberPage(String name, PullUpMethodPage page, PullUpRefactoringProcessor processor) {
        super(name);
        this.fSuccessorPage = page;
        this.fProcessor = processor;
        this.setDescription(RefactoringMessages.PullUpInputPage1_page_message);
        this.METHOD_LABELS = new String[2];
        this.METHOD_LABELS[0] = RefactoringMessages.PullUpInputPage1_pull_up;
        this.METHOD_LABELS[1] = RefactoringMessages.PullUpInputPage1_declare_abstract;
        this.TYPE_LABELS = new String[1];
        this.TYPE_LABELS[0] = RefactoringMessages.PullUpInputPage1_pull_up;
    }

    public PullUpRefactoringProcessor getPullUpRefactoringProcessor() {
        return this.fProcessor;
    }

    private boolean areAllMembersMarkedAsPullUp() {
        return this.getMembersForAction(0).length == this.getTableInput().length;
    }

    protected boolean areAllMembersMarkedAsWithNoAction() {
        return this.getMembersForAction(2).length == this.getTableInput().length;
    }

    private MemberActionInfo[] asMemberActionInfos() {
        List<IMember> toPullUp = Arrays.asList(this.fProcessor.getMembersToMove());
        IMember[] members = this.fProcessor.getPullableMembersOfDeclaringType();
        MemberActionInfo[] result = new MemberActionInfo[members.length];
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            result[i] = toPullUp.contains(member) ? new MemberActionInfo(member, 0) : new MemberActionInfo(member, 2);
            ++i;
        }
        return result;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void checkAdditionalRequired() {
        try {
            this.initializeRefactoring();
            class GetRequiredMembersRunnable
            implements IRunnableWithProgress {
                public IMember[] result;
                final /* synthetic */ PullUpMemberPage this$0;

                GetRequiredMembersRunnable(PullUpMemberPage pullUpMemberPage) {
                    this.this$0 = pullUpMemberPage;
                }

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        try {
                            this.result = PullUpMemberPage.access$1(this.this$0).getAdditionalRequiredMembersToPullUp(pm);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            }
            GetRequiredMembersRunnable runnable = new GetRequiredMembersRunnable(this);
            this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
            this.checkPullUp(runnable.result, true);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.PullUpInputPage_pull_Up, RefactoringMessages.PullUpInputPage_exception);
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
        }
    }

    protected void checkPageCompletionStatus(boolean displayErrors) {
        if (this.areAllMembersMarkedAsWithNoAction()) {
            if (displayErrors) {
                this.setErrorMessage(this.getNoMembersMessage());
            }
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        this.fSuccessorPage.fireSettingsChanged();
    }

    private void checkPullUp(IMember[] elements, boolean displayErrors) {
        this.setActionForMembers(elements, 0);
        this.updateWizardPage(null, displayErrors);
    }

    private void createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        this.fSelectAllButton = new Button(composite, 8);
        this.fSelectAllButton.setText(RefactoringMessages.PullUpWizard_select_all_label);
        this.fSelectAllButton.setLayoutData((Object)new GridData(768));
        this.fSelectAllButton.setEnabled(true);
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IMember[] members = PullUpMemberPage.this.getMembers();
                PullUpMemberPage.this.setActionForMembers(members, 0);
                PullUpMemberPage.this.updateWizardPage(null, true);
            }
        });
        this.fDeselectAllButton = new Button(composite, 8);
        this.fDeselectAllButton.setText(RefactoringMessages.PullUpWizard_deselect_all_label);
        this.fDeselectAllButton.setLayoutData((Object)new GridData(768));
        this.fDeselectAllButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IMember[] members = PullUpMemberPage.this.getMembers();
                PullUpMemberPage.this.setActionForMembers(members, 2);
                PullUpMemberPage.this.updateWizardPage(null, true);
            }
        });
        this.fEditButton = new Button(composite, 8);
        this.fEditButton.setText(RefactoringMessages.PullUpInputPage1_Edit);
        GridData data = new GridData(768);
        data.verticalIndent = new PixelConverter((Control)parent).convertVerticalDLUsToPixels(7);
        this.fEditButton.setLayoutData((Object)data);
        this.fEditButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PullUpMemberPage.this.editSelectedMembers();
            }
        });
        this.fAddButton = new Button(composite, 8);
        this.fAddButton.setText(RefactoringMessages.PullUpInputPage1_Add_Required);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PullUpMemberPage.this.checkAdditionalRequired();
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createSuperTypeControl(composite);
        this.createSpacer(composite);
        this.createSuperTypeCheckbox(composite);
        this.createInstanceOfCheckbox(composite, layout.marginWidth);
        this.createStubCheckbox(composite);
        this.createSpacer(composite);
        this.createMemberTableLabel(composite);
        this.createMemberTableComposite(composite);
        this.createStatusLine(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.initializeEnablement();
        this.initializeCheckboxes();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.pull_up_wizard_page_context");
    }

    protected void createInstanceOfCheckbox(Composite result, int margin) {
        this.fInstanceofButton = new Button(result, 32);
        this.fInstanceofButton.setSelection(false);
        GridData gd = new GridData();
        gd.horizontalIndent = margin + this.fInstanceofButton.computeSize((int)-1, (int)-1).x;
        gd.horizontalSpan = 2;
        this.fInstanceofButton.setLayoutData((Object)gd);
        this.fInstanceofButton.setText(this.getInstanceofButtonLabel());
        this.fProcessor.setInstanceOf(this.fInstanceofButton.getSelection());
        this.fInstanceofButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PullUpMemberPage.this.fProcessor.setInstanceOf(PullUpMemberPage.this.fInstanceofButton.getSelection());
            }
        });
        this.fReplaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PullUpMemberPage.this.fInstanceofButton.setEnabled(PullUpMemberPage.this.fReplaceButton.getSelection());
            }
        });
    }

    private void createMemberTable(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        Table table = new Table((Composite)layouter, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint(table, this.getTableRowCount());
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        layouter.setLayoutData(gd);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setText(RefactoringMessages.PullUpInputPage1_Member);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(RefactoringMessages.PullUpInputPage1_Action);
        this.fTableViewer = new PullPushCheckboxTableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemberActionInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PullUpMemberPage.this.updateButtonEnablement(event.getSelection());
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                MemberActionInfo info = (MemberActionInfo)event.getElement();
                if (checked) {
                    info.setAction(0);
                } else {
                    info.setAction(2);
                }
                PullUpMemberPage.this.updateWizardPage(null, true);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PullUpMemberPage.this.editSelectedMembers();
            }
        });
        this.setTableInput();
        this.checkPullUp(this.fProcessor.getMembersToMove(), false);
        this.setupCellEditors(table);
    }

    protected void createMemberTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createMemberTable(composite);
        this.createButtonComposite(composite);
    }

    protected void createMemberTableLabel(Composite parent) {
        this.fLabel = new Label(parent, 0);
        this.fLabel.setText(RefactoringMessages.PullUpInputPage1_Specify_actions);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fLabel.setLayoutData((Object)data);
    }

    protected void createSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)data);
    }

    protected void createStatusLine(Composite composite) {
        this.fStatusLine = new Label(composite, 0);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.updateStatusLine();
        this.fStatusLine.setLayoutData((Object)data);
    }

    private Map createStringMappingForSelectedMembers() {
        HashMap result = new HashMap();
        PullUpMemberPage.putToStringMapping(result, this.METHOD_LABELS, 0);
        PullUpMemberPage.putToStringMapping(result, this.METHOD_LABELS, 1);
        return result;
    }

    protected void createStubCheckbox(Composite parent) {
        this.fCreateStubsButton = new Button(parent, 32);
        this.fCreateStubsButton.setText(this.getCreateStubsButtonLabel());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fCreateStubsButton.setLayoutData((Object)data);
        this.fCreateStubsButton.setEnabled(false);
        this.fCreateStubsButton.setSelection(this.fProcessor.getCreateMethodStubs());
    }

    protected void createSuperTypeCheckbox(Composite parent) {
        this.fReplaceButton = new Button(parent, 32);
        this.fReplaceButton.setText(this.getReplaceButtonLabel());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fReplaceButton.setLayoutData((Object)data);
        this.fReplaceButton.setEnabled(true);
        this.fReplaceButton.setSelection(this.fProcessor.isReplace());
    }

    private void createSuperTypeCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(RefactoringMessages.PullUpInputPage1_Select_destination);
        label.setLayoutData((Object)new GridData());
        this.fSuperTypesCombo = new Combo(parent, 8);
        SWTUtil.setDefaultVisibleItemCount(this.fSuperTypesCombo);
        if (this.fCandidateTypes.length > 0) {
            int i = 0;
            while (i < this.fCandidateTypes.length) {
                String comboLabel = this.fCandidateTypes[i].getFullyQualifiedName('.');
                this.fSuperTypesCombo.add(comboLabel);
                ++i;
            }
            this.fSuperTypesCombo.select(this.fCandidateTypes.length - 1);
            this.fSuperTypesCombo.setLayoutData((Object)new GridData(768));
        }
    }

    protected void createSuperTypeControl(Composite parent) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            PullUpMemberPage.this.fCandidateTypes = PullUpMemberPage.this.fProcessor.getCandidateTypes(new RefactoringStatus(), monitor);
                        }
                        catch (JavaModelException exception) {
                            throw new InvocationTargetException(exception);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            this.createSuperTypeCombo(parent);
        }
        catch (InvocationTargetException exception) {
            ExceptionHandler.handle(exception, this.getShell(), RefactoringMessages.PullUpInputPage_pull_Up, RefactoringMessages.PullUpInputPage_exception);
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
        }
    }

    public void dispose() {
        this.fInstanceofButton = null;
        this.fReplaceButton = null;
        this.fTableViewer = null;
        super.dispose();
    }

    private void editSelectedMembers() {
        if (!this.fEditButton.isEnabled()) {
            return;
        }
        ISelection preserved = this.fTableViewer.getSelection();
        try {
            MemberActionInfo[] selectedMembers = this.getSelectedMembers();
            String shellTitle = RefactoringMessages.PullUpInputPage1_Edit_members;
            String labelText = selectedMembers.length == 1 ? Messages.format(RefactoringMessages.PullUpInputPage1_Mark_selected_members_singular, JavaElementLabels.getElementLabel((IJavaElement)selectedMembers[0].getMember(), 1L)) : Messages.format(RefactoringMessages.PullUpInputPage1_Mark_selected_members_plural, String.valueOf(selectedMembers.length));
            Map stringMapping = this.createStringMappingForSelectedMembers();
            Object[] keys = stringMapping.keySet().toArray(new String[stringMapping.keySet().size()]);
            Arrays.sort(keys);
            int initialSelectionIndex = this.getInitialSelectionIndexForEditDialog(stringMapping, (String[])keys);
            ComboSelectionDialog dialog = new ComboSelectionDialog(this.getShell(), shellTitle, labelText, (String[])keys, initialSelectionIndex);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                return;
            }
            int action = (Integer)stringMapping.get(dialog.getSelectedString());
            PullUpMemberPage.setActionForInfos(selectedMembers, action);
        }
        finally {
            this.updateWizardPage(preserved, true);
        }
    }

    private boolean enableEditButton(IStructuredSelection ss) {
        if (ss.isEmpty() || ss.size() == 0) {
            return false;
        }
        return ss.size() == PullUpMemberPage.getEditableCount(this.getSelectedMembers());
    }

    private MemberActionInfo[] getActiveInfos() {
        MemberActionInfo[] infos = this.getTableInput();
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(infos.length);
        int i = 0;
        while (i < infos.length) {
            MemberActionInfo info = infos[i];
            if (info.isActive()) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private int getCommonActionCodeForSelectedInfos() {
        MemberActionInfo[] infos = this.getSelectedMembers();
        if (infos.length == 0) {
            return -1;
        }
        int code = infos[0].getAction();
        int i = 0;
        while (i < infos.length) {
            if (code != infos[i].getAction()) {
                return -1;
            }
            ++i;
        }
        return code;
    }

    protected String getCreateStubsButtonLabel() {
        return RefactoringMessages.PullUpInputPage1_Create_stubs;
    }

    protected String getDeclareAbstractActionLabel() {
        return RefactoringMessages.PullUpInputPage1_declare_abstract;
    }

    public IType getDestinationType() {
        int index = this.fSuperTypesCombo.getSelectionIndex();
        if (index >= 0) {
            return this.fCandidateTypes[index];
        }
        return null;
    }

    private int getInitialSelectionIndexForEditDialog(Map stringMapping, String[] keys) {
        int commonActionCode = this.getCommonActionCodeForSelectedInfos();
        if (commonActionCode == -1) {
            return 0;
        }
        Iterator iter = stringMapping.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int action = (Integer)stringMapping.get(key);
            if (commonActionCode != action) continue;
            int i = 0;
            while (i < keys.length) {
                if (key.equals(keys[i])) {
                    return i;
                }
                ++i;
            }
            Assert.isTrue((boolean)false);
        }
        return 0;
    }

    protected String getInstanceofButtonLabel() {
        return RefactoringMessages.PullUpInputPage1_label_use_in_instanceof;
    }

    private IMember[] getMembers() {
        MemberActionInfo[] infos = this.getTableInput();
        ArrayList<IMember> result = new ArrayList<IMember>(infos.length);
        int index = 0;
        while (index < infos.length) {
            result.add(infos[index].getMember());
            ++index;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private IMember[] getMembersForAction(int action) {
        ArrayList result = new ArrayList();
        this.getMembersForAction(action, false, result);
        return result.toArray(new IMember[result.size()]);
    }

    private IMethod[] getMethodsForAction(int action) {
        ArrayList result = new ArrayList();
        this.getMembersForAction(action, true, result);
        return result.toArray(new IMethod[result.size()]);
    }

    private void getMembersForAction(int action, boolean onlyMethods, List result) {
        boolean isDestinationInterface = this.isDestinationInterface();
        MemberActionInfo[] infos = this.getTableInput();
        int index = 0;
        while (index < infos.length) {
            block6: {
                int infoAction;
                MemberActionInfo info;
                block7: {
                    info = infos[index];
                    infoAction = info.getAction();
                    boolean isMethodInfo = info.isMethodInfo();
                    if (!isMethodInfo && onlyMethods) break block6;
                    if (!isMethodInfo || !isDestinationInterface) break block7;
                    if (action == 0) break block6;
                    if (action == 1 && infoAction == 0) {
                        infoAction = 1;
                    }
                }
                if (infoAction == action) {
                    result.add(info.getMember());
                }
            }
            ++index;
        }
    }

    private boolean isDestinationInterface() {
        IType destination = this.getDestinationType();
        try {
            if (destination != null && destination.isInterface()) {
                return true;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        return false;
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        this.storeDialogSettings();
        if (this.getMethodsForAction(0).length == 0) {
            return this.computeSuccessorPage();
        }
        if (this.isDestinationInterface()) {
            return this.computeSuccessorPage();
        }
        return super.getNextPage();
    }

    protected String getNoMembersMessage() {
        return RefactoringMessages.PullUpInputPage1_Select_members_to_pull_up;
    }

    protected String getPullUpActionLabel() {
        return RefactoringMessages.PullUpInputPage1_pull_up;
    }

    protected String getReplaceButtonLabel() {
        return RefactoringMessages.PullUpInputPage1_label_use_destination;
    }

    private MemberActionInfo[] getSelectedMembers() {
        Assert.isTrue((boolean)(this.fTableViewer.getSelection() instanceof IStructuredSelection));
        IStructuredSelection structured = (IStructuredSelection)this.fTableViewer.getSelection();
        List result = structured.toList();
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private MemberActionInfo[] getTableInput() {
        return (MemberActionInfo[])this.fTableViewer.getInput();
    }

    protected int getTableRowCount() {
        return 10;
    }

    private void initializeCheckBox(Button checkbox, String property, boolean def) {
        String s = JavaPlugin.getDefault().getDialogSettings().get(property);
        if (s != null) {
            checkbox.setSelection(new Boolean(s).booleanValue());
        } else {
            checkbox.setSelection(def);
        }
    }

    protected void initializeCheckboxes() {
        this.initializeCheckBox(this.fReplaceButton, SETTING_REPLACE, true);
        this.initializeCheckBox(this.fInstanceofButton, SETTING_INSTANCEOF, false);
    }

    protected void initializeEnablement() {
        MemberActionInfo[] infos = this.asMemberActionInfos();
        boolean enabled = infos.length > 0;
        this.fTableViewer.getTable().setEnabled(enabled);
        this.fStatusLine.setEnabled(enabled);
        this.fAddButton.setEnabled(enabled);
        this.fLabel.setEnabled(enabled);
    }

    private void initializeRefactoring() {
        this.fProcessor.setMembersToMove(this.getMembersForAction(0));
        this.fProcessor.setAbstractMethods(this.getMethodsForAction(1));
        IType destination = this.getDestinationType();
        if (destination != null) {
            this.fProcessor.setDestinationType(destination);
        }
        this.fProcessor.setCreateMethodStubs(this.fCreateStubsButton.getSelection());
        this.fProcessor.setReplace(this.fReplaceButton.getSelection());
        this.fProcessor.setInstanceOf(this.fInstanceofButton.getSelection());
        this.fProcessor.setDeletedMethods(this.getMethodsForAction(0));
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        this.storeDialogSettings();
        return super.performFinish();
    }

    private void setActionForMembers(IMember[] members, int action) {
        MemberActionInfo[] infos = this.getTableInput();
        int i = 0;
        while (i < members.length) {
            int j = 0;
            while (j < infos.length) {
                if (infos[j].getMember().equals(members[i])) {
                    infos[j].setAction(action);
                }
                ++j;
            }
            ++i;
        }
    }

    private void setTableInput() {
        this.fTableViewer.setInput((Object)this.asMemberActionInfos());
    }

    private void setupCellEditors(final Table table) {
        final ComboBoxCellEditor editor = new ComboBoxCellEditor();
        editor.setStyle(8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = editor;
        this.fTableViewer.setCellEditors(cellEditorArray);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel;
                if (editor.getControl() == null & !table.isDisposed()) {
                    editor.create((Composite)table);
                }
                if (!((sel = event.getSelection()) instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structured = (IStructuredSelection)sel;
                if (structured.size() != 1) {
                    return;
                }
                MemberActionInfo info = (MemberActionInfo)structured.getFirstElement();
                editor.setItems(info.getAllowedLabels());
                editor.setValue((Object)new Integer(info.getAction()));
            }
        });
        MemberActionCellModifier cellModifier = new MemberActionCellModifier();
        this.fTableViewer.setCellModifier((ICellModifier)cellModifier);
        this.fTableViewer.setColumnProperties(new String[]{MEMBER_PROPERTY, ACTION_PROPERTY});
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.fProcessor.resetEnvironment();
            }
            finally {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
                this.fTableViewer.getControl().setFocus();
            }
        }
    }

    private void storeDialogSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        settings.put(SETTING_REPLACE, this.fReplaceButton.getSelection());
        settings.put(SETTING_INSTANCEOF, this.fInstanceofButton.getSelection());
    }

    private void updateButtonEnablement(ISelection selection) {
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.enableEditButton((IStructuredSelection)selection));
        }
        this.fCreateStubsButton.setEnabled(this.getMethodsForAction(1).length != 0);
        this.fInstanceofButton.setEnabled(this.fReplaceButton.getSelection());
        if (this.fSelectAllButton != null) {
            this.fSelectAllButton.setEnabled(!this.areAllMembersMarkedAsPullUp());
        }
        if (this.fDeselectAllButton != null) {
            this.fDeselectAllButton.setEnabled(!this.areAllMembersMarkedAsWithNoAction());
        }
    }

    private void updateStatusLine() {
        if (this.fStatusLine == null) {
            return;
        }
        Object[] selectedMembers = this.fTableViewer.getCheckedElements();
        int selected = selectedMembers.length;
        String msg = selected == 1 ? Messages.format(RefactoringMessages.PullUpInputPage1_status_line_singular, JavaElementLabels.getElementLabel((IJavaElement)((MemberActionInfo)selectedMembers[0]).getMember(), 1L)) : Messages.format(RefactoringMessages.PullUpInputPage1_status_line_plural, String.valueOf(selected));
        this.fStatusLine.setText(msg);
    }

    private void updateWizardPage(ISelection selection, boolean displayErrors) {
        this.fTableViewer.refresh();
        if (selection != null) {
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(selection);
        }
        this.checkPageCompletionStatus(displayErrors);
        this.updateButtonEnablement(this.fTableViewer.getSelection());
        this.updateStatusLine();
    }

    private class MemberActionCellModifier
    implements ICellModifier {
        private MemberActionCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (!PullUpMemberPage.ACTION_PROPERTY.equals(property)) {
                return false;
            }
            return ((MemberActionInfo)element).isEditable();
        }

        public Object getValue(Object element, String property) {
            if (!PullUpMemberPage.ACTION_PROPERTY.equals(property)) {
                return null;
            }
            MemberActionInfo info = (MemberActionInfo)element;
            return new Integer(info.getAction());
        }

        public void modify(Object element, String property, Object value) {
            if (!PullUpMemberPage.ACTION_PROPERTY.equals(property)) {
                return;
            }
            int action = (Integer)value;
            MemberActionInfo info = element instanceof Item ? (MemberActionInfo)((Item)element).getData() : (MemberActionInfo)element;
            if (!this.canModify(info, property)) {
                return;
            }
            Assert.isTrue((boolean)info.isMethodInfo());
            info.setAction(action);
            PullUpMemberPage.this.updateWizardPage(null, true);
        }
    }

    private class MemberActionInfo
    implements IMemberActionInfo {
        private static final int NO_ACTION = 2;
        private int fAction;
        private final IMember fMember;

        public MemberActionInfo(IMember member, int action) {
            Assert.isTrue((member instanceof IMethod || member instanceof IField || member instanceof IType ? 1 : 0) != 0);
            this.assertAction(member, action);
            this.fMember = member;
            this.fAction = action;
        }

        private void assertAction(IMember member, int action) {
            if (member instanceof IMethod) {
                try {
                    Assert.isTrue((action != 1 || !JdtFlags.isStatic(member) ? 1 : 0) != 0);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                Assert.isTrue((action == 2 || action == 1 || action == 0 ? 1 : 0) != 0);
            } else {
                Assert.isTrue((action == 2 || action == 0 ? 1 : 0) != 0);
            }
        }

        public int getAction() {
            return this.fAction;
        }

        public String getActionLabel() {
            switch (this.fAction) {
                case 0: {
                    return PullUpMemberPage.this.getPullUpActionLabel();
                }
                case 1: {
                    return PullUpMemberPage.this.getDeclareAbstractActionLabel();
                }
                case 2: {
                    return "";
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String[] getAllowedLabels() {
            if (this.isFieldInfo()) {
                return new String[]{""};
            }
            if (this.isMethodInfo()) {
                return PullUpMemberPage.this.METHOD_LABELS;
            }
            if (this.isTypeInfo()) {
                return PullUpMemberPage.this.TYPE_LABELS;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public IMember getMember() {
            return this.fMember;
        }

        public boolean isActive() {
            return this.getAction() != 2;
        }

        public boolean isEditable() {
            if (this.fAction == 2) {
                return false;
            }
            if (!this.isMethodInfo()) {
                return false;
            }
            IMethod method = (IMethod)this.fMember;
            try {
                return !JdtFlags.isStatic((IMember)method);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return false;
            }
        }

        public boolean isFieldInfo() {
            return this.getMember() instanceof IField;
        }

        public boolean isMethodInfo() {
            return this.getMember() instanceof IMethod;
        }

        public boolean isTypeInfo() {
            return this.getMember() instanceof IType;
        }

        public void setAction(int action) {
            this.assertAction(this.fMember, action);
            this.fAction = action;
        }
    }

    private static class MemberActionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final ILabelProvider fLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

        private MemberActionInfoLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            this.fLabelProvider.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            MemberActionInfo info = (MemberActionInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fLabelProvider.getImage((Object)info.getMember());
                }
                case 1: {
                    return null;
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MemberActionInfo info = (MemberActionInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fLabelProvider.getText((Object)info.getMember());
                }
                case 1: {
                    return info.getActionLabel();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

