/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;

public class CleanUpProfileVersioner
implements IProfileVersioner {
    public static final String PROFILE_KIND = "CleanUpProfile";
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    public static final int CURRENT_VERSION = 2;

    public int getFirstVersion() {
        return 1;
    }

    public int getCurrentVersion() {
        return 2;
    }

    public void update(ProfileManager.CustomProfile profile) {
        Map oldSettings = profile.getSettings();
        Map newSettings = this.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(2);
        profile.setSettings(newSettings);
    }

    private Map updateAndComplete(Map oldSettings, int version) {
        Map newSettings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1).getMap();
        switch (version) {
            case 1: {
                CleanUpProfileVersioner.updateFrom1To2(oldSettings);
            }
        }
        Iterator iter = oldSettings.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (!newSettings.containsKey(key) || (value = (String)oldSettings.get(key)) == null) continue;
            newSettings.put(key, value);
        }
        return newSettings;
    }

    public String getProfileKind() {
        return PROFILE_KIND;
    }

    private static void updateFrom1To2(Map settings) {
        MapCleanUpOptions defaultSettings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1);
        settings.put("cleanup.organize_imports", defaultSettings.getValue("cleanup.organize_imports"));
    }
}

