/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;

public class ProfileModificationJob
extends ProvisioningJob
implements IProfileChangeJob {
    IProvisioningPlan plan;
    String profileId;
    IPhaseSet phaseSet = PhaseSetFactory.createDefaultPhaseSet();
    ProvisioningContext provisioningContext;
    int restartPolicy = 2;
    private String taskName;

    public ProfileModificationJob(String name, ProvisioningSession session, String profileId, IProvisioningPlan plan, ProvisioningContext context) {
        super(name, session);
        this.plan = plan;
        this.profileId = profileId;
        this.provisioningContext = context;
    }

    public void setPhaseSet(IPhaseSet phaseSet) {
        this.phaseSet = phaseSet;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public IStatus runModal(IProgressMonitor monitor) {
        String task = this.taskName;
        IStatus status = Status.OK_STATUS;
        if (task == null) {
            task = this.getName();
        }
        monitor.beginTask(task, 1000);
        try {
            status = this.getSession().performProvisioningPlan(this.plan, this.phaseSet, this.provisioningContext, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public void setTaskName(String label) {
        this.taskName = label;
    }

    public int getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(int policy) {
        this.restartPolicy = policy;
    }
}

