/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.SourceLocationKey;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.importing.IBundleImporter;
import org.eclipse.pde.internal.core.importing.provisional.BundleImportDescription;
import org.eclipse.pde.internal.core.project.BundleProjectService;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferenceNode;
import org.eclipse.pde.internal.ui.provisional.IBundeImportWizardPage;
import org.eclipse.pde.internal.ui.wizards.imports.AlternateSourceLocations;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardExpressPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class PluginImportWizardFirstPage
extends WizardPage {
    private static final String SETTINGS_IMPORTTYPE = "importType";
    private static final String SETTINGS_FROM = "importFrom";
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_SCAN_ALL = "scanAll";
    private static final int FROM_ACTIVE_PLATFORM = 1;
    private static final int FROM_TARGET_DEFINITION = 2;
    private static final int FROM_DIRECTORY = 3;
    private Button importActiveTargetButton;
    private Button browseButton;
    private Button importDirectoryButton;
    private Button importTargetDefinitionButton;
    private Combo targetDefinitionCombo;
    private List targetDefinitions;
    private Combo importDirectory;
    private Button openTargetPrefsButton;
    private Button importButton;
    private Button scanButton;
    private Button binaryButton;
    private Button binaryWithLinksButton;
    private Button sourceButton;
    private Button repositoryButton;
    public static String TARGET_PLATFORM = "targetPlatform";
    private IPluginModelBase[] models = new IPluginModelBase[0];
    private SourceLocationManager alternateSource;
    private PDEState state;
    private boolean canceled = false;
    protected Set repositoryModels = new HashSet();
    private Map importerToInstructions = new HashMap();
    private Map importIdToWizardPage = new HashMap();
    private List nextPages = new ArrayList();
    static /* synthetic */ Class class$0;

    public PluginImportWizardFirstPage(String name) {
        super(name);
        this.setTitle(PDEUIMessages.ImportWizard_FirstPage_title);
        this.setMessage(PDEUIMessages.ImportWizard_FirstPage_desc);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 1, 1, 1808);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createImportFromGroup(container);
        this.createImportChoicesGroup(container);
        this.createImportOptionsGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.initialize();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugin_import_first_page");
    }

    private void createImportChoicesGroup(Composite container) {
        Group importChoices = SWTFactory.createGroup(container, PDEUIMessages.ImportWizard_FirstPage_importGroup, 1, 1, 768);
        this.scanButton = SWTFactory.createRadioButton((Composite)importChoices, PDEUIMessages.ImportWizard_FirstPage_scanAll);
        this.importButton = SWTFactory.createRadioButton((Composite)importChoices, PDEUIMessages.ImportWizard_FirstPage_importPrereqs);
    }

    private void createImportOptionsGroup(Composite container) {
        Group options = SWTFactory.createGroup(container, PDEUIMessages.ImportWizard_FirstPage_importAs, 1, 1, 768);
        this.binaryButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_binary);
        this.binaryWithLinksButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_binaryLinks);
        this.sourceButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_source);
        this.repositoryButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.PluginImportWizardFirstPage_3);
    }

    private void initialize() {
        IDialogSettings settings = this.getDialogSettings();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            String curr = settings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.importDirectory.setItems(items.toArray(new String[items.size()]));
        this.refreshTargetDropDown();
        int source = 1;
        try {
            source = settings.getInt(SETTINGS_FROM);
        }
        catch (NumberFormatException numberFormatException) {}
        this.importDirectory.select(0);
        this.targetDefinitionCombo.select(0);
        this.updateSourceGroup(source);
        int importType = 1;
        try {
            importType = settings.getInt(SETTINGS_IMPORTTYPE);
        }
        catch (NumberFormatException numberFormatException) {}
        if (importType == 1) {
            this.binaryButton.setSelection(true);
        } else if (importType == 2) {
            this.binaryWithLinksButton.setSelection(true);
        } else if (importType == 3) {
            this.sourceButton.setSelection(true);
        } else {
            this.repositoryButton.setSelection(true);
        }
        boolean scan = true;
        if (settings.get(SETTINGS_SCAN_ALL) != null) {
            scan = settings.getBoolean(SETTINGS_SCAN_ALL);
        }
        this.scanButton.setSelection(scan);
        this.importButton.setSelection(!scan);
    }

    private void updateSourceGroup(int source) {
        this.importActiveTargetButton.setSelection(source == 1);
        this.importTargetDefinitionButton.setSelection(source == 2);
        this.targetDefinitionCombo.setEnabled(source == 2);
        this.importDirectoryButton.setSelection(source == 3);
        this.importDirectory.setEnabled(source == 3);
        this.browseButton.setEnabled(source == 3);
        if (source == 1) {
            this.importDirectory.setText(this.getTargetHome());
        }
    }

    private void refreshTargetDropDown() {
        ITargetPlatformService service = this.getTargetPlatformService();
        if (service != null) {
            ITargetHandle[] targets = service.getTargets(null);
            this.targetDefinitions = new ArrayList();
            int i = 0;
            while (i < targets.length) {
                try {
                    this.targetDefinitions.add(targets[i].getTargetDefinition());
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
                ++i;
            }
            Collections.sort(this.targetDefinitions, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ITargetDefinition td1 = (ITargetDefinition)o1;
                    ITargetDefinition td2 = (ITargetDefinition)o2;
                    String name1 = td1.getName() == null ? "" : td1.getName();
                    String name2 = td2.getName() == null ? "" : td2.getName();
                    return name1.compareTo(name2);
                }
            });
            String[] names = new String[this.targetDefinitions.size()];
            int i2 = 0;
            while (i2 < this.targetDefinitions.size()) {
                ITargetDefinition currentTarget = (ITargetDefinition)this.targetDefinitions.get(i2);
                names[i2] = currentTarget.getName();
                if (names[i2] == null || names[i2].trim().length() == 0) {
                    names[i2] = currentTarget.getHandle().toString();
                }
                ++i2;
            }
            this.targetDefinitionCombo.setItems(names);
        }
    }

    private ITargetPlatformService getTargetPlatformService() {
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITargetPlatformService service = (ITargetPlatformService)pDECore.acquireService(clazz.getName());
        return service;
    }

    private void createImportFromGroup(Composite parent) {
        Group composite = SWTFactory.createGroup(parent, PDEUIMessages.ImportWizard_FirstPage_importFrom, 3, 1, 768);
        this.importActiveTargetButton = SWTFactory.createRadioButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_target, 3);
        this.importActiveTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.updateSourceGroup(PluginImportWizardFirstPage.this.getImportOrigin());
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.importTargetDefinitionButton = SWTFactory.createRadioButton((Composite)composite, PDEUIMessages.PluginImportWizardFirstPage_0, 1);
        this.importTargetDefinitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.updateSourceGroup(PluginImportWizardFirstPage.this.getImportOrigin());
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.targetDefinitionCombo = SWTFactory.createCombo((Composite)composite, 12, 1, 768, null);
        this.targetDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.openTargetPrefsButton = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_goToTarget, null);
        this.openTargetPrefsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferenceNode targetNode;
                ITargetDefinition selected = PluginImportWizardFirstPage.this.getTargetDefinition();
                ITargetHandle handle = null;
                if (selected != null) {
                    handle = selected.getHandle();
                }
                if (PluginImportWizardFirstPage.this.showPreferencePage(targetNode = new TargetPlatformPreferenceNode(), PluginImportWizardFirstPage.this.getShell())) {
                    PluginImportWizardFirstPage.this.refreshTargetDropDown();
                    int index = -1;
                    if (handle != null) {
                        int i = 0;
                        while (i < PluginImportWizardFirstPage.this.targetDefinitions.size()) {
                            ITargetHandle h = ((ITargetDefinition)PluginImportWizardFirstPage.this.targetDefinitions.get(i)).getHandle();
                            if (h.equals(handle)) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (index == -1 && PluginImportWizardFirstPage.this.targetDefinitions.size() > 0) {
                        index = 0;
                    }
                    if (index >= 0) {
                        PluginImportWizardFirstPage.this.targetDefinitionCombo.select(index);
                    }
                    PluginImportWizardFirstPage.this.importDirectory.setText(TargetPlatform.getLocation());
                }
            }
        });
        this.importDirectoryButton = SWTFactory.createRadioButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_otherFolder, 1);
        this.importDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardFirstPage.this.updateSourceGroup(PluginImportWizardFirstPage.this.getImportOrigin());
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.importDirectory = SWTFactory.createCombo((Composite)composite, 4, 1, 768, null);
        this.importDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginImportWizardFirstPage.this.validateDropLocation();
            }
        });
        this.browseButton = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_browse, null, 256);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = PluginImportWizardFirstPage.this.chooseDropLocation();
                if (chosen != null) {
                    PluginImportWizardFirstPage.this.importDirectory.setText(chosen.toOSString());
                }
            }
        });
    }

    private boolean showPreferencePage(final IPreferenceNode targetNode, Shell shell) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(shell, manager);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.importDirectory.getText());
        dialog.setText(PDEUIMessages.ImportWizard_messages_folder_title);
        dialog.setMessage(PDEUIMessages.ImportWizard_messages_folder_message);
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private String getTargetHome() {
        PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
        return preferences.getString("platform_path");
    }

    public boolean getScanAllPlugins() {
        return this.scanButton.getSelection();
    }

    public int getImportType() {
        if (this.binaryButton.getSelection()) {
            return 1;
        }
        if (this.binaryWithLinksButton.getSelection()) {
            return 2;
        }
        if (this.repositoryButton.getSelection()) {
            return 4;
        }
        return 3;
    }

    public SourceLocationManager getAlternateSourceLocations() {
        return this.alternateSource;
    }

    public String getDropLocation() {
        return this.importActiveTargetButton.getSelection() ? TARGET_PLATFORM : this.importDirectory.getText().trim();
    }

    public void storeSettings() {
        boolean other;
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = other = !this.importActiveTargetButton.getSelection();
        if (this.importDirectory.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.importDirectory.getText().trim());
            String[] items = this.importDirectory.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        settings.put(SETTINGS_FROM, this.getImportOrigin());
        settings.put(SETTINGS_IMPORTTYPE, this.getImportType());
        settings.put(SETTINGS_SCAN_ALL, this.getScanAllPlugins());
    }

    private int getImportOrigin() {
        int source = 1;
        if (this.importTargetDefinitionButton.getSelection()) {
            source = 2;
        } else if (this.importDirectoryButton.getSelection()) {
            source = 3;
        }
        return source;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void validateDropLocation() {
        if (this.importTargetDefinitionButton.getSelection() && this.targetDefinitionCombo.getText().length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage(PDEUIMessages.PluginImportWizardFirstPage_2);
            return;
        }
        if (this.importDirectoryButton.getSelection()) {
            Path curr = new Path(this.importDirectory.getText());
            if (curr.segmentCount() == 0 && curr.getDevice() == null) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_locationMissing);
                this.setPageComplete(false);
                return;
            }
            if (!Path.ROOT.isValidPath(this.importDirectory.getText())) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_buildFolderInvalid);
                this.setPageComplete(false);
                return;
            }
            if (!curr.toFile().isDirectory()) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_buildFolderMissing);
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(PDEUIMessages.ImportWizard_FirstPage_desc);
    }

    private void resolveTargetPlatform(final int type) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                PluginImportWizardFirstPage.this.models = PluginRegistry.getExternalModels();
                PluginImportWizardFirstPage.this.state = PDECore.getDefault().getModelManager().getState();
                PluginImportWizardFirstPage.this.alternateSource = null;
                try {
                    PluginImportWizardFirstPage.this.buildImportDescriptions(monitor, type);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void resolveArbitraryLocation(String location) {
        ITargetPlatformService service = this.getTargetPlatformService();
        if (service != null) {
            File plugins = new File(location, "plugins");
            IBundleContainer container = null;
            container = plugins.exists() ? service.newDirectoryContainer(plugins.getAbsolutePath()) : service.newDirectoryContainer(location);
            ITargetDefinition target = service.newTarget();
            target.setBundleContainers(new IBundleContainer[]{container});
            this.resolveTargetDefinition(target, this.getImportType());
        }
    }

    private void resolveTargetDefinition(final ITargetDefinition target, final int type) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(PDEUIMessages.PluginImportWizardFirstPage_1, 100);
                SubProgressMonitor pm = new SubProgressMonitor(monitor, 50);
                target.resolve((IProgressMonitor)pm);
                pm.done();
                if (monitor.isCanceled()) {
                    return;
                }
                IResolvedBundle[] bundles = target.getBundles();
                HashMap<SourceLocationKey, IResolvedBundle> sourceMap = new HashMap<SourceLocationKey, IResolvedBundle>();
                URL[] all = new URL[bundles.length];
                int i = 0;
                while (i < bundles.length) {
                    IResolvedBundle bundle = bundles[i];
                    try {
                        if (bundle.getStatus().isOK()) {
                            all[i] = new File(bundle.getBundleInfo().getLocation()).toURL();
                            if (bundle.isSourceBundle()) {
                                sourceMap.put(new SourceLocationKey(bundle.getBundleInfo().getSymbolicName(), new Version(bundle.getBundleInfo().getVersion())), bundle);
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        PluginImportWizardFirstPage.this.setErrorMessage(e.getMessage());
                        monitor.setCanceled(true);
                        return;
                    }
                    ++i;
                }
                pm = new SubProgressMonitor(monitor, 50);
                PluginImportWizardFirstPage.this.state = new PDEState(all, false, (IProgressMonitor)pm);
                PluginImportWizardFirstPage.this.models = PluginImportWizardFirstPage.this.state.getTargetModels();
                ArrayList<IPluginModelBase> sourceModels = new ArrayList<IPluginModelBase>();
                ArrayList<IResolvedBundle> sourceBundles = new ArrayList<IResolvedBundle>();
                int i2 = 0;
                while (i2 < PluginImportWizardFirstPage.this.models.length) {
                    IPluginBase base = PluginImportWizardFirstPage.this.models[i2].getPluginBase();
                    IResolvedBundle bundle = (IResolvedBundle)sourceMap.get(new SourceLocationKey(base.getId(), new Version(base.getVersion())));
                    if (bundle != null) {
                        sourceModels.add(PluginImportWizardFirstPage.this.models[i2]);
                        sourceBundles.add(bundle);
                    }
                    ++i2;
                }
                PluginImportWizardFirstPage.this.alternateSource = new AlternateSourceLocations(sourceModels.toArray(new IPluginModelBase[sourceModels.size()]), sourceBundles.toArray(new IResolvedBundle[sourceBundles.size()]));
                try {
                    PluginImportWizardFirstPage.this.buildImportDescriptions((IProgressMonitor)pm, type);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                pm.done();
                PluginImportWizardFirstPage.this.canceled = monitor.isCanceled();
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void buildImportDescriptions(IProgressMonitor monitor, int type) throws CoreException {
        BundleProjectService service = (BundleProjectService)BundleProjectService.getDefault();
        this.repositoryModels.clear();
        this.importerToInstructions.clear();
        this.nextPages.clear();
        if (type == 4) {
            Map.Entry entry;
            Iterator iterator;
            if (this.models != null) {
                this.importerToInstructions = service.getImportDescriptions(this.models);
                iterator = this.importerToInstructions.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (monitor.isCanceled()) continue;
                    entry = iterator.next();
                    BundleImportDescription[] descriptions = (BundleImportDescription[])entry.getValue();
                    int i = 0;
                    while (i < descriptions.length) {
                        this.repositoryModels.add(descriptions[i].getProperty("PLUGIN"));
                        ++i;
                    }
                }
            }
            if (!monitor.isCanceled()) {
                iterator = this.importerToInstructions.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    IBundleImporter importer = (IBundleImporter)entry.getKey();
                    IBundeImportWizardPage page = (IBundeImportWizardPage)this.importIdToWizardPage.get(importer.getId());
                    if (page == null && (page = this.getPage(importer.getId())) != null) {
                        this.importIdToWizardPage.put(importer.getId(), page);
                        ((Wizard)this.getWizard()).addPage((IWizardPage)page);
                    }
                    if (page == null) continue;
                    this.nextPages.add(page);
                }
            }
        }
        if (monitor.isCanceled()) {
            this.importerToInstructions.clear();
            this.repositoryModels.clear();
            this.nextPages.clear();
        }
    }

    boolean arePagesComplete() {
        Iterator iterator = this.nextPages.iterator();
        while (iterator.hasNext()) {
            IBundeImportWizardPage page = (IBundeImportWizardPage)iterator.next();
            if (page.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    boolean finishPages() {
        Iterator iterator = this.nextPages.iterator();
        while (iterator.hasNext()) {
            IBundeImportWizardPage page = (IBundeImportWizardPage)iterator.next();
            if (page.finish()) continue;
            return false;
        }
        return true;
    }

    Map getImportDescriptions() {
        HashMap<IBundleImporter, BundleImportDescription[]> map = new HashMap<IBundleImporter, BundleImportDescription[]>();
        if (this.getImportType() == 4) {
            IBundleImporter[] importers = ((BundleProjectService)BundleProjectService.getDefault()).getBundleImporters();
            int i = 0;
            while (i < importers.length) {
                IBundeImportWizardPage page;
                IBundleImporter importer = importers[i];
                if (this.importerToInstructions.containsKey(importer) && (page = (IBundeImportWizardPage)this.importIdToWizardPage.get(importer.getId())) != null && this.nextPages.contains(page)) {
                    map.put(importer, page.getSelection());
                }
                ++i;
            }
        }
        return map;
    }

    IWizardPage getNextPage(IWizardPage page) {
        int index;
        if (this.nextPages.isEmpty()) {
            return null;
        }
        if (page instanceof IBundeImportWizardPage && (index = this.nextPages.indexOf(page)) >= 0 && index < this.nextPages.size() - 2) {
            return (IWizardPage)this.nextPages.get(index + 1);
        }
        if (page instanceof PluginImportWizardDetailedPage || page instanceof PluginImportWizardExpressPage) {
            return (IWizardPage)this.nextPages.get(0);
        }
        return null;
    }

    IWizardPage getPreviousPage(IWizardPage page) {
        int index;
        if (page instanceof IBundeImportWizardPage && (index = this.nextPages.indexOf(page)) > 0) {
            return (IWizardPage)this.nextPages.get(index - 1);
        }
        return null;
    }

    private IBundeImportWizardPage getPage(String importerId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.pde.ui.bundleImportPages");
        if (point != null) {
            IConfigurationElement[] infos = point.getConfigurationElements();
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement element = infos[i];
                String id = element.getAttribute("bundleImporter");
                if (id != null && importerId.equals(id)) {
                    try {
                        return (IBundeImportWizardPage)element.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public IPluginModelBase[] getModels() {
        switch (this.getImportOrigin()) {
            case 1: {
                this.resolveTargetPlatform(this.getImportType());
                break;
            }
            case 2: {
                this.resolveTargetDefinition(this.getTargetDefinition(), this.getImportType());
                break;
            }
            case 3: {
                this.resolveArbitraryLocation(this.getDropLocation());
            }
        }
        return this.models;
    }

    public PDEState getState() {
        return this.state;
    }

    private ITargetDefinition getTargetDefinition() {
        int index = this.targetDefinitionCombo.getSelectionIndex();
        if (index >= 0 && this.targetDefinitions.size() > 0) {
            return (ITargetDefinition)this.targetDefinitions.get(this.targetDefinitionCombo.getSelectionIndex());
        }
        return null;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean isRefreshNeeded() {
        if (this.canceled) {
            this.canceled = false;
            return true;
        }
        return false;
    }

    public Object getImportSource() {
        switch (this.getImportOrigin()) {
            case 2: {
                return this.getTargetDefinition();
            }
        }
        return this.getDropLocation();
    }

    public void configureBundleImportPages(IPluginModelBase[] models) {
        IBundleImporter importer;
        Map.Entry entry;
        HashSet<IPluginModelBase> modelsSet = new HashSet<IPluginModelBase>();
        int i = 0;
        while (i < models.length) {
            modelsSet.add(models[i]);
            ++i;
        }
        HashMap<IBundleImporter, ArrayList<BundleImportDescription>> importerToImportees = new HashMap<IBundleImporter, ArrayList<BundleImportDescription>>();
        Iterator iterator = this.importerToInstructions.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            importer = (IBundleImporter)entry.getKey();
            BundleImportDescription[] descriptions = (BundleImportDescription[])entry.getValue();
            int i2 = 0;
            while (i2 < descriptions.length) {
                IPluginModelBase model = (IPluginModelBase)descriptions[i2].getProperty("PLUGIN");
                if (modelsSet.contains(model)) {
                    ArrayList<BundleImportDescription> importees = (ArrayList<BundleImportDescription>)importerToImportees.get(importer);
                    if (importees == null) {
                        importees = new ArrayList<BundleImportDescription>();
                        importerToImportees.put(importer, importees);
                    }
                    importees.add(descriptions[i2]);
                }
                ++i2;
            }
        }
        iterator = importerToImportees.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            importer = (IBundleImporter)entry.getKey();
            List list = (List)entry.getValue();
            BundleImportDescription[] descriptions = list.toArray(new BundleImportDescription[list.size()]);
            IBundeImportWizardPage page = (IBundeImportWizardPage)this.importIdToWizardPage.get(importer.getId());
            if (page == null) continue;
            page.setSelection(descriptions);
        }
    }
}

