/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    private final int op;
    private static final int EQUAL = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final int PRESENT = 5;
    private static final int SUBSTRING = 6;
    private static final int AND = 7;
    private static final int OR = 8;
    private static final int NOT = 9;
    private final String attr;
    private final Object value;
    private volatile transient String filterString;
    private static final Class[] constructorType;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        constructorType = classArray;
    }

    public static FilterImpl newInstance(String filterString) throws InvalidSyntaxException {
        return new Parser(filterString).parse();
    }

    public boolean match(ServiceReference reference) {
        if (reference instanceof ServiceReferenceImpl) {
            return this.match0(((ServiceReferenceImpl)reference).getRegistration().getProperties());
        }
        return this.match0(new ServiceReferenceDictionary(reference));
    }

    public boolean match(Dictionary dictionary) {
        if (dictionary != null) {
            dictionary = new Headers(dictionary);
        }
        return this.match0(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match0(dictionary);
    }

    public String toString() {
        String result = this.filterString;
        if (result == null) {
            this.filterString = result = this.normalize();
        }
        return result;
    }

    private String normalize() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        switch (this.op) {
            case 7: {
                sb.append('&');
                FilterImpl[] filters = (FilterImpl[])this.value;
                int i = 0;
                int size = filters.length;
                while (i < size) {
                    sb.append(filters[i].normalize());
                    ++i;
                }
                break;
            }
            case 8: {
                sb.append('|');
                FilterImpl[] filters = (FilterImpl[])this.value;
                int i = 0;
                int size = filters.length;
                while (i < size) {
                    sb.append(filters[i].normalize());
                    ++i;
                }
                break;
            }
            case 9: {
                sb.append('!');
                FilterImpl filter = (FilterImpl)this.value;
                sb.append(filter.normalize());
                break;
            }
            case 6: {
                sb.append(this.attr);
                sb.append('=');
                String[] substrings = (String[])this.value;
                int i = 0;
                int size = substrings.length;
                while (i < size) {
                    String substr = substrings[i];
                    if (substr == null) {
                        sb.append('*');
                    } else {
                        sb.append(FilterImpl.encodeValue(substr));
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                sb.append(this.attr);
                sb.append('=');
                sb.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 3: {
                sb.append(this.attr);
                sb.append(">=");
                sb.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 4: {
                sb.append(this.attr);
                sb.append("<=");
                sb.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 2: {
                sb.append(this.attr);
                sb.append("~=");
                sb.append(FilterImpl.encodeValue(FilterImpl.approxString((String)this.value)));
                break;
            }
            case 5: {
                sb.append(this.attr);
                sb.append("=*");
            }
        }
        sb.append(')');
        return ((Object)sb).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    FilterImpl(int operation, String attr, Object value) {
        this.op = operation;
        this.attr = attr;
        this.value = value;
    }

    private boolean match0(Dictionary properties) {
        switch (this.op) {
            case 7: {
                FilterImpl[] filters = (FilterImpl[])this.value;
                int i = 0;
                int size = filters.length;
                while (i < size) {
                    if (!filters[i].match0(properties)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filters = (FilterImpl[])this.value;
                int i = 0;
                int size = filters.length;
                while (i < size) {
                    if (filters[i].match0(properties)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 9: {
                FilterImpl filter = (FilterImpl)this.value;
                return !filter.match0(properties);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object prop = properties == null ? null : properties.get(this.attr);
                return this.compare(this.op, prop, this.value);
            }
            case 5: {
                Object prop;
                if (Debug.DEBUG_FILTER) {
                    Debug.println("PRESENT(" + this.attr + ")");
                }
                Object v0 = prop = properties == null ? null : properties.get(this.attr);
                return prop != null;
            }
        }
        return false;
    }

    private static String encodeValue(String value) {
        boolean encoded = false;
        int inlen = value.length();
        int outlen = inlen << 1;
        char[] output = new char[outlen];
        value.getChars(0, inlen, output, inlen);
        int cursor = 0;
        int i = inlen;
        while (i < outlen) {
            char c = output[i];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    output[cursor] = 92;
                    ++cursor;
                    encoded = true;
                }
            }
            output[cursor] = c;
            ++cursor;
            ++i;
        }
        return encoded ? new String(output, 0, cursor) : value;
    }

    private boolean compare(int operation, Object value1, Object value2) {
        if (value1 == null) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("compare(" + value1 + "," + value2 + ")");
            }
            return false;
        }
        if (value1 instanceof String) {
            return this.compare_String(operation, (String)value1, value2);
        }
        Class<?> clazz = value1.getClass();
        if (clazz.isArray()) {
            Class<?> type = clazz.getComponentType();
            if (type.isPrimitive()) {
                return this.compare_PrimitiveArray(operation, type, value1, value2);
            }
            return this.compare_ObjectArray(operation, (Object[])value1, value2);
        }
        if (value1 instanceof Collection) {
            return this.compare_Collection(operation, (Collection)value1, value2);
        }
        if (value1 instanceof Integer) {
            return this.compare_Integer(operation, (Integer)value1, value2);
        }
        if (value1 instanceof Long) {
            return this.compare_Long(operation, (Long)value1, value2);
        }
        if (value1 instanceof Byte) {
            return this.compare_Byte(operation, (Byte)value1, value2);
        }
        if (value1 instanceof Short) {
            return this.compare_Short(operation, (Short)value1, value2);
        }
        if (value1 instanceof Character) {
            return this.compare_Character(operation, ((Character)value1).charValue(), value2);
        }
        if (value1 instanceof Float) {
            return this.compare_Float(operation, ((Float)value1).floatValue(), value2);
        }
        if (value1 instanceof Double) {
            return this.compare_Double(operation, (Double)value1, value2);
        }
        if (value1 instanceof Boolean) {
            return this.compare_Boolean(operation, (Boolean)value1, value2);
        }
        if (value1 instanceof Comparable) {
            return this.compare_Comparable(operation, (Comparable)value1, value2);
        }
        return this.compare_Unknown(operation, value1, value2);
    }

    private boolean compare_Collection(int operation, Collection collection, Object value2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.compare(operation, iterator.next(), value2)) continue;
            return true;
        }
        return false;
    }

    private boolean compare_ObjectArray(int operation, Object[] array, Object value2) {
        int i = 0;
        int size = array.length;
        while (i < size) {
            if (this.compare(operation, array[i], value2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean compare_PrimitiveArray(int operation, Class type, Object primarray, Object value2) {
        if (Integer.TYPE.isAssignableFrom(type)) {
            int[] array = (int[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Integer(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            long[] array = (long[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Long(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            byte[] array = (byte[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Byte(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            short[] array = (short[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Short(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            char[] array = (char[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Character(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            float[] array = (float[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Float(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            double[] array = (double[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Double(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            boolean[] array = (boolean[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare_Boolean(operation, array[i], value2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compare_String(int operation, String string, Object value2) {
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + string + "," + value2 + ")");
                }
                String[] substrings = (String[])value2;
                int pos = 0;
                int i = 0;
                int size = substrings.length;
                while (i < size) {
                    String substr = substrings[i];
                    if (i + 1 < size) {
                        if (substr == null) {
                            String substr2 = substrings[i + 1];
                            if (substr2 != null) {
                                int index;
                                if (Debug.DEBUG_FILTER) {
                                    Debug.println("indexOf(\"" + substr2 + "\"," + pos + ")");
                                }
                                if ((index = string.indexOf(substr2, pos)) == -1) {
                                    return false;
                                }
                                pos = index + substr2.length();
                                if (i + 2 < size) {
                                    ++i;
                                }
                            }
                        } else {
                            int len = substr.length();
                            if (Debug.DEBUG_FILTER) {
                                Debug.println("regionMatches(" + pos + ",\"" + substr + "\")");
                            }
                            if (!string.regionMatches(pos, substr, 0, len)) return false;
                            pos += len;
                        }
                    } else {
                        if (substr == null) {
                            return true;
                        }
                        if (!Debug.DEBUG_FILTER) return string.endsWith(substr);
                        Debug.println("regionMatches(" + pos + "," + substr + ")");
                        return string.endsWith(substr);
                    }
                    ++i;
                }
                return true;
            }
            case 1: {
                if (!Debug.DEBUG_FILTER) return string.equals(value2);
                Debug.println("EQUAL(" + string + "," + value2 + ")");
                return string.equals(value2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + string + "," + value2 + ")");
                }
                string = FilterImpl.approxString(string);
                String string2 = FilterImpl.approxString((String)value2);
                return string.equalsIgnoreCase(string2);
            }
            case 3: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)value2) >= 0;
                Debug.println("GREATER(" + string + "," + value2 + ")");
                return string.compareTo((String)value2) >= 0;
            }
            case 4: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)value2) <= 0;
                Debug.println("LESS(" + string + "," + value2 + ")");
                return string.compareTo((String)value2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Integer(int operation, int intval, Object value2) {
        int intval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + intval + "," + value2 + ")");
            }
            return false;
        }
        try {
            intval2 = Integer.parseInt(((String)value2).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + intval + "," + value2 + ")");
                }
                return intval == intval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + intval + "," + value2 + ")");
                }
                return intval == intval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + intval + "," + value2 + ")");
                }
                return intval >= intval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + intval + "," + value2 + ")");
                }
                return intval <= intval2;
            }
        }
        return false;
    }

    private boolean compare_Long(int operation, long longval, Object value2) {
        long longval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + longval + "," + value2 + ")");
            }
            return false;
        }
        try {
            longval2 = Long.parseLong(((String)value2).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + longval + "," + value2 + ")");
                }
                return longval == longval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + longval + "," + value2 + ")");
                }
                return longval == longval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + longval + "," + value2 + ")");
                }
                return longval >= longval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + longval + "," + value2 + ")");
                }
                return longval <= longval2;
            }
        }
        return false;
    }

    private boolean compare_Byte(int operation, byte byteval, Object value2) {
        byte byteval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + byteval + "," + value2 + ")");
            }
            return false;
        }
        try {
            byteval2 = Byte.parseByte(((String)value2).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + byteval + "," + value2 + ")");
                }
                return byteval == byteval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + byteval + "," + value2 + ")");
                }
                return byteval == byteval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + byteval + "," + value2 + ")");
                }
                return byteval >= byteval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + byteval + "," + value2 + ")");
                }
                return byteval <= byteval2;
            }
        }
        return false;
    }

    private boolean compare_Short(int operation, short shortval, Object value2) {
        short shortval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + shortval + "," + value2 + ")");
            }
            return false;
        }
        try {
            shortval2 = Short.parseShort(((String)value2).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + shortval + "," + value2 + ")");
                }
                return shortval == shortval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + shortval + "," + value2 + ")");
                }
                return shortval == shortval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + shortval + "," + value2 + ")");
                }
                return shortval >= shortval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + shortval + "," + value2 + ")");
                }
                return shortval <= shortval2;
            }
        }
        return false;
    }

    private boolean compare_Character(int operation, char charval, Object value2) {
        char charval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + charval + "," + value2 + ")");
            }
            return false;
        }
        try {
            charval2 = ((String)value2).charAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + charval + "," + value2 + ")");
                }
                return charval == charval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + charval + "," + value2 + ")");
                }
                return charval == charval2 || Character.toUpperCase(charval) == Character.toUpperCase(charval2) || Character.toLowerCase(charval) == Character.toLowerCase(charval2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + charval + "," + value2 + ")");
                }
                return charval >= charval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + charval + "," + value2 + ")");
                }
                return charval <= charval2;
            }
        }
        return false;
    }

    private boolean compare_Boolean(int operation, boolean boolval, Object value2) {
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + boolval + "," + value2 + ")");
            }
            return false;
        }
        boolean boolval2 = Boolean.valueOf(((String)value2).trim());
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
        }
        return false;
    }

    private boolean compare_Float(int operation, float floatval, Object value2) {
        float floatval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + floatval + "," + value2 + ")");
            }
            return false;
        }
        try {
            floatval2 = Float.parseFloat(((String)value2).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + floatval + "," + value2 + ")");
                }
                return Float.compare(floatval, floatval2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + floatval + "," + value2 + ")");
                }
                return Float.compare(floatval, floatval2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + floatval + "," + value2 + ")");
                }
                return Float.compare(floatval, floatval2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + floatval + "," + value2 + ")");
                }
                return Float.compare(floatval, floatval2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Double(int operation, double doubleval, Object value2) {
        double doubleval2;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + doubleval + "," + value2 + ")");
            }
            return false;
        }
        try {
            doubleval2 = Double.parseDouble(((String)value2).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + doubleval + "," + value2 + ")");
                }
                return Double.compare(doubleval, doubleval2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + doubleval + "," + value2 + ")");
                }
                return Double.compare(doubleval, doubleval2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + doubleval + "," + value2 + ")");
                }
                return Double.compare(doubleval, doubleval2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + doubleval + "," + value2 + ")");
                }
                return Double.compare(doubleval, doubleval2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Comparable(int operation, Comparable value1, Object value2) {
        Constructor<?> constructor;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + value1 + "," + value2 + ")");
            }
            return false;
        }
        try {
            constructor = value1.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            value2 = constructor.newInstance(((String)value2).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Unknown(int operation, Object value1, Object value2) {
        Constructor<?> constructor;
        if (operation == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + value1 + "," + value2 + ")");
            }
            return false;
        }
        try {
            constructor = value1.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("Type not supported");
            }
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            value2 = constructor.newInstance(((String)value2).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (operation) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
        }
        return false;
    }

    private static String approxString(String input) {
        boolean changed = false;
        char[] output = input.toCharArray();
        int cursor = 0;
        int i = 0;
        int length = output.length;
        while (i < length) {
            char c = output[i];
            if (Character.isWhitespace(c)) {
                changed = true;
            } else {
                output[cursor] = c;
                ++cursor;
            }
            ++i;
        }
        return changed ? new String(output, 0, cursor) : input;
    }

    public String getRequiredObjectClass() {
        switch (this.op) {
            case 1: {
                if (!this.attr.equalsIgnoreCase("objectClass") || !(this.value instanceof String)) break;
                return (String)this.value;
            }
            case 7: {
                FilterImpl[] clauses = (FilterImpl[])this.value;
                int i = 0;
                while (i < clauses.length) {
                    String result;
                    if (clauses[i].op == 1 && (result = clauses[i].getRequiredObjectClass()) != null) {
                        return result;
                    }
                    ++i;
                }
                break;
            }
        }
        return null;
    }

    public String[] getAttributes() {
        ArrayList results = new ArrayList();
        this.getAttributesInternal(results);
        return results.toArray(new String[results.size()]);
    }

    private void getAttributesInternal(ArrayList results) {
        if (this.value instanceof FilterImpl[]) {
            FilterImpl[] children = (FilterImpl[])this.value;
            int i = 0;
            while (i < children.length) {
                children[i].getAttributesInternal(results);
                ++i;
            }
            return;
        }
        if (this.value instanceof FilterImpl) {
            ((FilterImpl)this.value).getAttributesInternal(results);
            return;
        }
        if (this.attr != null) {
            results.add(this.attr);
        }
    }

    private static class Parser {
        private final String filterstring;
        private final char[] filterChars;
        private int pos;

        Parser(String filterstring) {
            this.filterstring = filterstring;
            this.filterChars = filterstring.toCharArray();
            this.pos = 0;
        }

        FilterImpl parse() throws InvalidSyntaxException {
            FilterImpl filter;
            try {
                filter = this.parse_filter();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring);
            }
            if (this.pos != this.filterChars.length) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return filter;
        }

        private FilterImpl parse_filter() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            FilterImpl filter = this.parse_filtercomp();
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != ')') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
            return filter;
        }

        private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filterChars[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    return this.parse_and();
                }
                case '|': {
                    ++this.pos;
                    return this.parse_or();
                }
                case '!': {
                    ++this.pos;
                    return this.parse_not();
                }
            }
            return this.parse_item();
        }

        private FilterImpl parse_and() throws InvalidSyntaxException {
            int lookahead = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = lookahead - 1;
                return this.parse_item();
            }
            ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl child = this.parse_filter();
                operands.add(child);
            }
            return new FilterImpl(7, null, operands.toArray(new FilterImpl[operands.size()]));
        }

        private FilterImpl parse_or() throws InvalidSyntaxException {
            int lookahead = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = lookahead - 1;
                return this.parse_item();
            }
            ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl child = this.parse_filter();
                operands.add(child);
            }
            return new FilterImpl(8, null, operands.toArray(new FilterImpl[operands.size()]));
        }

        private FilterImpl parse_not() throws InvalidSyntaxException {
            int lookahead = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = lookahead - 1;
                return this.parse_item();
            }
            FilterImpl child = this.parse_filter();
            return new FilterImpl(9, null, child);
        }

        private FilterImpl parse_item() throws InvalidSyntaxException {
            String attr = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filterChars[this.pos]) {
                case '~': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(2, attr, this.parse_value());
                }
                case '>': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(3, attr, this.parse_value());
                }
                case '<': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(4, attr, this.parse_value());
                }
                case '=': {
                    if (this.filterChars[this.pos + 1] == '*') {
                        int oldpos = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filterChars[this.pos] == ')') {
                            return new FilterImpl(5, attr, null);
                        }
                        this.pos = oldpos;
                    }
                    ++this.pos;
                    Object string = this.parse_substring();
                    if (string instanceof String) {
                        return new FilterImpl(1, attr, string);
                    }
                    return new FilterImpl(6, attr, string);
                }
            }
            throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, this.filterstring.substring(this.pos)), this.filterstring);
        }

        private String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int begin = this.pos;
            int end = this.pos;
            char c = this.filterChars[this.pos];
            while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    end = this.pos;
                }
                c = this.filterChars[this.pos];
            }
            int length = end - begin;
            if (length == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return new String(this.filterChars, begin, length);
        }

        private String parse_value() throws InvalidSyntaxException {
            StringBuffer sb = new StringBuffer(this.filterChars.length - this.pos);
            block5: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (sb.length() == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return ((Object)sb).toString();
        }

        private Object parse_substring() throws InvalidSyntaxException {
            Object single;
            int size;
            StringBuffer sb = new StringBuffer(this.filterChars.length - this.pos);
            ArrayList<String> operands = new ArrayList<String>(10);
            block6: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        if (sb.length() <= 0) break block6;
                        operands.add(((Object)sb).toString());
                        break block6;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '*': {
                        if (sb.length() > 0) {
                            operands.add(((Object)sb).toString());
                        }
                        sb.setLength(0);
                        operands.add(null);
                        ++this.pos;
                        continue block6;
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            if ((size = operands.size()) == 0) {
                return "";
            }
            if (size == 1 && (single = operands.get(0)) != null) {
                return single;
            }
            return operands.toArray(new String[size]);
        }

        private void skipWhiteSpace() {
            int length = this.filterChars.length;
            while (this.pos < length && Character.isWhitespace(this.filterChars[this.pos])) {
                ++this.pos;
            }
        }
    }

    private static class ServiceReferenceDictionary
    extends Dictionary {
        private final ServiceReference reference;

        ServiceReferenceDictionary(ServiceReference reference) {
            this.reference = reference;
        }

        public Object get(Object key) {
            if (this.reference == null) {
                return null;
            }
            return this.reference.getProperty((String)key);
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Enumeration keys() {
            throw new UnsupportedOperationException();
        }

        public Enumeration elements() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SetAccessibleAction
    implements PrivilegedAction {
        private final AccessibleObject accessible;

        SetAccessibleAction(AccessibleObject accessible) {
            this.accessible = accessible;
        }

        public Object run() {
            this.accessible.setAccessible(true);
            return null;
        }
    }
}

