/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.sync;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.ui.sync.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.spi.ISemanticFileHistoryProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.SemanticResourceVariant;
import org.eclipse.core.resources.semantic.spi.SemanticResourceVariantComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class SemanticSubscriber
extends Subscriber {
    final Map<IPath, SyncInfo> outOfSync = new HashMap<IPath, SyncInfo>();
    private final boolean threeWay;

    public SemanticSubscriber(boolean threeWay) {
        this.threeWay = threeWay;
    }

    public String getName() {
        return Messages.SemanticSubscriber_SfsSubsriberName_XGRP;
    }

    public IResourceVariantComparator getResourceComparator() {
        return new SemanticResourceVariantComparator(this.threeWay);
    }

    public synchronized SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (!resource.exists()) {
            return null;
        }
        try {
            IFileRevision[] revs;
            ISemanticFileStore sfs;
            ISemanticFileHistoryProvider fhp;
            IFileStore store = EFS.getStore((URI)resource.getLocationURI());
            if (store instanceof ISemanticFileStore && (fhp = (ISemanticFileHistoryProvider)(sfs = (ISemanticFileStore)store).getEffectiveContentProvider().getAdapter(ISemanticFileHistoryProvider.class)) != null && (revs = fhp.getResourceVariants(sfs, null)) != null) {
                IResourceVariant[] var = SemanticSubscriber.toVariants(revs, sfs);
                SyncInfo syncinfo = new SyncInfo(resource, var[0], var[1], this.getResourceComparator());
                syncinfo.init();
                if (!SyncInfo.isInSync((int)syncinfo.getKind())) {
                    this.outOfSync.put(resource.getFullPath(), syncinfo);
                } else {
                    this.outOfSync.remove(resource.getFullPath());
                }
                return syncinfo;
            }
        }
        catch (CoreException e) {
            TeamException ex = new TeamException(e.getStatus());
            throw ex;
        }
        return null;
    }

    public static IResourceVariant[] toVariants(IFileRevision[] revs, ISemanticFileStore store) {
        IResourceVariant[] result = new IResourceVariant[revs.length];
        int i = 0;
        while (i < revs.length) {
            IFileRevision rev = revs[i];
            if (rev != null) {
                result[i] = new SemanticResourceVariant(rev, store);
            }
            ++i;
        }
        return result;
    }

    public boolean isSupervised(IResource resource) {
        return true;
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource instanceof IContainer) {
            try {
                return ((IContainer)resource).members();
            }
            catch (CoreException e) {
                throw new TeamException(e.getMessage(), (Throwable)e);
            }
        }
        return new IResource[0];
    }

    public synchronized void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        final ArrayList events = new ArrayList();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            try {
                res.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        SyncInfo info = SemanticSubscriber.this.outOfSync.get(resource.getFullPath());
                        if (info != null) {
                            events.add(new SubscriberChangeEvent((Subscriber)SemanticSubscriber.this, 1, resource));
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                throw new TeamException(e.getStatus());
            }
            ++n2;
        }
        this.fireTeamResourceChange(events.toArray(new ISubscriberChangeEvent[0]));
    }

    public IResource[] roots() {
        IProject[] projects;
        ArrayList<IProject> rootList = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)iProject, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
            if (provider != null) {
                rootList.add(iProject);
            }
            ++n2;
        }
        return rootList.toArray(new IResource[0]);
    }
}

