/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.SemanticResourcesUIPlugin;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SFSNavigator
extends CommonNavigator
implements ITabbedPropertySheetPageContributor {
    public static final String VIEW_ID = "org.eclipse.core.resources.semantic.resourceView";
    private static final long AUTOREFREH_MILLI = 5000L;
    boolean autoRefreshActive = true;
    IAction autoRefreshAction;
    Job autoRefreshJob;

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SFSBrowserTreeObject sfs;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.getFirstElement() instanceof SFSBrowserTreeObject && !(sfs = (SFSBrowserTreeObject)sel.getFirstElement()).getInfo().isDirectory()) {
                    try {
                        ISemanticFileStore sfstore = (ISemanticFileStore)sfs.getStore();
                        File tempFile = sfstore.toLocalFile(4096, (IProgressMonitor)new NullProgressMonitor());
                        FileStoreEditorInput input = new FileStoreEditorInput(EFS.getStore((URI)tempFile.toURI())){

                            public String getName() {
                                return sfs.getStore().getName();
                            }
                        };
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor");
                    }
                    catch (CoreException e) {
                        SemanticResourcesUIPlugin.handleError(e.getMessage(), e, true);
                    }
                }
            }
        });
        Action refreshAction = new Action(Messages.SFSNavigator_Refresh_XBUT){

            public void run() {
                SFSNavigator.this.getCommonViewer().refresh();
            }
        };
        refreshAction.setImageDescriptor(SemanticResourcesUIPlugin.getInstance().getImageRegistry().getDescriptor("refresh"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)refreshAction);
        this.autoRefreshAction = new Action(Messages.SFSNavigator_AutoRefresh_XMIT, 2){

            public void run() {
                if (this.isChecked()) {
                    if (SFSNavigator.this.autoRefreshJob == null) {
                        SFSNavigator.this.autoRefreshJob = new Job("Auto-refesh of SFS Browser"){

                            protected IStatus run(IProgressMonitor monitor) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        SFSNavigator.this.getCommonViewer().refresh();
                                    }
                                });
                                if (this.isChecked()) {
                                    this.schedule(5000L);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        SFSNavigator.this.autoRefreshJob.setSystem(true);
                    }
                    SFSNavigator.this.autoRefreshJob.schedule();
                } else if (SFSNavigator.this.autoRefreshJob != null) {
                    SFSNavigator.this.autoRefreshJob.cancel();
                    SFSNavigator.this.autoRefreshJob = null;
                }
            }
        };
        if (this.autoRefreshActive) {
            this.autoRefreshAction.setChecked(true);
            this.autoRefreshAction.run();
        }
        this.getViewSite().getActionBars().getMenuManager().add(this.autoRefreshAction);
    }

    public void dispose() {
        super.dispose();
        if (this.autoRefreshJob != null) {
            this.autoRefreshJob.cancel();
            this.autoRefreshJob = null;
        }
    }

    public void init(IViewSite site, IMemento aMemento) throws PartInitException {
        super.init(site, aMemento);
        if (aMemento == null) {
            return;
        }
        Boolean value = aMemento.getBoolean("AutoRefreshActive");
        if (value != null) {
            this.autoRefreshActive = value;
        }
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        aMemento.putBoolean("AutoRefreshActive", this.autoRefreshAction.isChecked());
    }
}

