/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationProviderPair;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationConfiguratorSelection;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsPresenter;
import org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui.CategoryPageObject;
import org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui.DestinationPageObject;
import org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui.DestinationsPreferencePagePageObject;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DestinationsPreferencePageTest {
    private static final String CATEGORY_ID = "my.category.id";
    private static final String CATEGORY_NAME = "My Category";
    private static final String DESTINATION_PROVIDER_ID = "my.dest.provider.id";
    private static final String DESTINATION_NAME = "My Destination";
    private String currentDestinationName;
    private DestinationsPreferencePagePageObject pageObject;
    @Mock
    private IDestinationConfiguratorsPresenter presenter;
    @Mock
    private IDestinationCategoryDescription category;
    @Mock
    private IDestinationsProviderDescription destinationProviderDescr;
    @Mock
    private IDestinationsProvider destinationProvider;
    @Mock
    private ISearchDestination destination;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.stubDestinations();
        this.pageObject = new DestinationsPreferencePagePageObject(this.presenter);
        this.pageObject.open();
        this.pageObject.setInput(this.createPageInput());
        ((IDestinationConfiguratorsPresenter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DestinationsPreferencePageTest.this.pageObject.getView().setAddEnabled(true);
                DestinationsPreferencePageTest.this.pageObject.getView().setRemoveEnabled(true);
                DestinationsPreferencePageTest.this.pageObject.getView().setEditEnabled(true);
                DestinationsPreferencePageTest.this.pageObject.getView().setTestEnabled(true);
                return null;
            }
        }).when((Object)this.presenter)).selectionChanged((DestinationConfiguratorSelection)Mockito.any(DestinationConfiguratorSelection.class));
    }

    private void stubDestinations() {
        this.currentDestinationName = DESTINATION_NAME;
        Mockito.stub((Object)this.destination.getDisplayName()).toAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return DestinationsPreferencePageTest.this.currentDestinationName;
            }
        });
        Mockito.stub((Object)this.destinationProvider.getSearchDestinations()).toReturn(new HashSet<ISearchDestination>(Arrays.asList(this.destination)));
        Mockito.stub((Object)this.destinationProviderDescr.createProvider()).toReturn((Object)this.destinationProvider);
        Mockito.stub((Object)this.destinationProviderDescr.getId()).toReturn((Object)DESTINATION_PROVIDER_ID);
        Mockito.stub((Object)this.category.getId()).toReturn((Object)CATEGORY_ID);
        Mockito.stub((Object)this.category.getDisplayName()).toReturn((Object)CATEGORY_NAME);
    }

    private Collection<CategoryDestinationProviderPair> createPageInput() {
        ArrayList<CategoryDestinationProviderPair> result = new ArrayList<CategoryDestinationProviderPair>();
        result.add(new CategoryDestinationProviderPair(this.category, this.destinationProviderDescr));
        return result;
    }

    @After
    public void tearDown() {
        this.pageObject.close();
    }

    @Test
    public void testNoDestinationsSelected() {
        Assert.assertFalse((String)"Adding destination is unexpectedly enabled", (boolean)this.pageObject.canAddDestination());
        Assert.assertFalse((String)"Removing destination is unexpectedly enabled", (boolean)this.pageObject.canRemoveDestination());
        Assert.assertFalse((String)"Editing destination is unexpectedly enabled", (boolean)this.pageObject.canEditDestination());
        Assert.assertFalse((String)"Testing destination is unexpectedly enabled", (boolean)this.pageObject.canTestDestination());
    }

    @Test
    public void testEnableAdd() {
        this.pageObject.setAddEnabled(true);
        Assert.assertTrue((String)"Adding destination is unexpectedly disabled", (boolean)this.pageObject.canAddDestination());
    }

    @Test
    public void testEnableEdit() {
        this.pageObject.setEditEnabled(true);
        Assert.assertTrue((String)"Editing destination is unexpectedly disabled", (boolean)this.pageObject.canEditDestination());
    }

    @Test
    public void testEnableRemove() {
        this.pageObject.setRemoveEnabled(true);
        Assert.assertTrue((String)"Removing destination is unexpectedly disabled", (boolean)this.pageObject.canRemoveDestination());
    }

    @Test
    public void testEnableTest() {
        this.pageObject.setTestEnabled(true);
        Assert.assertTrue((String)"Testingdestination is unexpectedly disabled", (boolean)this.pageObject.canTestDestination());
    }

    @Test
    public void testSetErrorStatus() throws InterruptedException {
        this.setStatusTest(this.createStatus(4, "Some error"));
    }

    @Test
    public void testSetWarningStatus() throws InterruptedException {
        this.setStatusTest(this.createStatus(2, "Some warning"));
    }

    @Test
    public void testSetCancelStatus() throws InterruptedException {
        this.setStatusTest(this.createStatus(8, "Cancelled"));
    }

    @Test
    public void testSetOkStatus() throws InterruptedException {
        this.setStatusTest(this.createStatus(0, "Success"));
    }

    @Test
    public void testSelectCategory() {
        this.pageObject.getCategory(CATEGORY_NAME).select();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.atLeastOnce())).selectionChanged((DestinationConfiguratorSelection)Mockito.argThat(this.selectionMatcher(DESTINATION_PROVIDER_ID, null)));
    }

    @Test
    public void testSelectDestination() {
        this.selectTheDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.atLeastOnce())).selectionChanged((DestinationConfiguratorSelection)Mockito.argThat(this.selectionMatcher(DESTINATION_PROVIDER_ID, this.destination)));
    }

    @Test
    public void testAddDestination() {
        this.selectTheDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DestinationsPreferencePageTest.this.pageObject.setInput(DestinationsPreferencePageTest.this.createPageInput());
                return null;
            }
        }).when((Object)this.presenter)).addDestination();
        this.pageObject.addDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter)).addDestination();
        this.assertCategoryIsExpanded();
        this.assertDestinationIsSelected(DESTINATION_NAME);
    }

    @Test
    public void testEditDestination() {
        this.selectTheDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DestinationsPreferencePageTest.this.currentDestinationName = "ModifiedDestinationName";
                DestinationsPreferencePageTest.this.pageObject.setInput(DestinationsPreferencePageTest.this.createPageInput());
                return null;
            }
        }).when((Object)this.presenter)).editDestination();
        this.pageObject.editDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter)).editDestination();
        this.assertCategoryIsExpanded();
        this.assertDestinationIsSelected("ModifiedDestinationName");
    }

    private void assertCategoryIsExpanded() {
        CategoryPageObject category = this.pageObject.getCategory(CATEGORY_NAME);
        Assert.assertTrue((String)"Category does not display destinations after edit", (boolean)category.isDestinationsVisible());
    }

    private void assertDestinationIsSelected(String destinationName) {
        DestinationPageObject destination = this.pageObject.getCategory(CATEGORY_NAME).getDestination(destinationName);
        Assert.assertTrue((String)"Destination is not selected", (boolean)destination.isSelected());
    }

    @Test
    public void testRemoveDestination() {
        this.selectTheDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DestinationsPreferencePageTest.this.pageObject.setInput(DestinationsPreferencePageTest.this.createPageInput());
                return null;
            }
        }).when((Object)this.presenter)).removeDestination();
        this.pageObject.removeDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter)).removeDestination();
        this.assertCategoryIsExpanded();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter)).selectionChanged((DestinationConfiguratorSelection)Mockito.argThat(this.emptySelectionMatcher()));
    }

    private Matcher<DestinationConfiguratorSelection> emptySelectionMatcher() {
        return new BaseMatcher<DestinationConfiguratorSelection>(){

            public boolean matches(Object item) {
                DestinationConfiguratorSelection selection = (DestinationConfiguratorSelection)item;
                return selection.destination == null && selection.destProviderId == null;
            }

            public void describeTo(Description description) {
            }
        };
    }

    @Test
    public void testTestDestination() {
        this.selectTheDestination();
        this.pageObject.testDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.verify((Object)this.presenter)).testDestination();
    }

    @Test
    public void testSelectionPreservedOnDestinationEdit() {
        this.selectTheDestination();
        ((IDestinationConfiguratorsPresenter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                DestinationsPreferencePageTest.this.currentDestinationName = "ModifiedDestinationName";
                DestinationsPreferencePageTest.this.pageObject.setInput(DestinationsPreferencePageTest.this.createPageInput());
                return null;
            }
        }).when((Object)this.presenter)).editDestination();
        this.pageObject.editDestination();
        DestinationPageObject selectedDestination = this.pageObject.getCategory(CATEGORY_NAME).getDestination("ModifiedDestinationName");
        Assert.assertTrue((String)"Modified destination lost its selection", (boolean)selectedDestination.isSelected());
    }

    private void selectTheDestination() {
        this.pageObject.getCategory(CATEGORY_NAME).getDestination(DESTINATION_NAME).select();
    }

    private Matcher<DestinationConfiguratorSelection> selectionMatcher(String destinationProviderId, final ISearchDestination destination) {
        return new BaseMatcher<DestinationConfiguratorSelection>(){

            public boolean matches(Object item) {
                DestinationConfiguratorSelection selection = (DestinationConfiguratorSelection)item;
                return selection.destProviderId != null && selection.destProviderId.equals(DestinationsPreferencePageTest.DESTINATION_PROVIDER_ID) && selection.destination == destination;
            }

            public void describeTo(Description description) {
            }
        };
    }

    private void setStatusTest(final IStatus status) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                DestinationsPreferencePageTest.this.pageObject.getView().setStatus(status);
            }
        });
        Assert.assertEquals((String)"Unexpected status displayed", (Object)(status.getSeverity() == 0 ? "" : status.getMessage()), (Object)this.pageObject.getDisplayedStatus());
    }

    private IStatus createStatus(int severity, String message) {
        IStatus status = (IStatus)Mockito.mock(IStatus.class);
        Mockito.stub((Object)status.getSeverity()).toReturn((Object)severity);
        Mockito.stub((Object)status.getMessage()).toReturn((Object)message);
        return status;
    }
}

