/*******************************************************************************
 * Copyright (c) 2010 SAP AG, Walldorf.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAP AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;


public class ExceptionHelper {
	
	static public RuntimeException rethrow(Exception t) throws LongOpCanceledException, InvocationTargetException
	{
		if (t instanceof RuntimeException) {
			throw (RuntimeException)t;
		} else if (t instanceof LongOpCanceledException)
		{
			throw (LongOpCanceledException)t;
		} else
		{
			throw new InvocationTargetException(t);
		}
	}

}
