/*******************************************************************************
 * Copyright (c) 2010 SAP AG, Walldorf.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAP AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.platform.discovery.core.api;


/**
 * Interface for describing a sub search context
 * @author Danail Branekov
 */
public interface ISubSearchContext
{
	/**
	 * Retrieves the subsearch result 
	 */
	public Object subSearchResult();
	
	/**
	 * Retrieves a description of this subsearch
	 */
	public String subSearchDescription();
	
	/**
	 * Retrieves the title of this subsearch
	 */
	public String subSearchTitle();
	
	/**
	 * The search context which 
	 * @return
	 */
	public ISearchContext searchContext();
}
