/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Util {
    private static final byte[] buffer = new byte[8192];
    private static final String EMPTY = "";

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transferStreams(InputStream source, OutputStream destination, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor actMonitor = Util.monitorFor(monitor);
        try {
            byte[] byArray = buffer;
            synchronized (buffer) {
                while (true) {
                    int bytesRead = -1;
                    try {
                        bytesRead = source.read(buffer);
                    }
                    catch (IOException e) {
                        throw new SemanticResourceException(SemanticResourceStatusCode.UTIL_BYTE_TRANSER, (IPath)new Path(EMPTY), Messages.Util_TransferRead_XMSG, e);
                    }
                    if (bytesRead == -1) break;
                    try {
                        destination.write(buffer, 0, bytesRead);
                    }
                    catch (IOException e) {
                        throw new SemanticResourceException(SemanticResourceStatusCode.UTIL_BYTE_TRANSER, (IPath)new Path(EMPTY), Messages.Util_TransferWrite_XMSG, e);
                    }
                    actMonitor.worked(1);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            Util.safeClose(source);
            Util.safeClose(destination);
        }
        {
            return;
        }
    }

    public static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void safeClose(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }
}

