/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class SemanticResourceVariantComparator
implements IResourceVariantComparator {
    private final boolean threeWay;

    public SemanticResourceVariantComparator(boolean threeWay) {
        this.threeWay = threeWay;
    }

    public boolean compare(IResource local, IResourceVariant remote) {
        if (!(local instanceof IFile)) {
            return true;
        }
        try {
            String filestamp = Long.toString(((IFile)local).getLocalTimeStamp());
            String remoteStamp = new String(remote.asBytes(), "UTF-8");
            return remoteStamp.equals(filestamp);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public boolean compare(IResourceVariant base, IResourceVariant remote) {
        try {
            String baseStamp = new String(base.asBytes(), "UTF-8");
            String remoteStamp = new String(base.asBytes(), "UTF-8");
            return baseStamp.equals(remoteStamp);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public boolean isThreeWay() {
        return this.threeWay;
    }
}

