/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.CachedResourceVariant;

public class SemanticResourceVariant
extends CachedResourceVariant {
    private final ISemanticFileStore myStore;
    private IFileRevision myRevision;

    public SemanticResourceVariant(IFileRevision revision, ISemanticFileStore store) {
        this.myRevision = revision;
        this.myStore = store;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        try {
            this.setContents(this.myRevision.getStorage(monitor).getContents(), monitor);
        }
        catch (CoreException e) {
            TeamException ex = new TeamException(e.getStatus());
            throw ex;
        }
    }

    protected String getCacheId() {
        return "org.eclipse.core.resources.semantic";
    }

    protected String getCachePath() {
        return this.myStore.getPath().append(this.myRevision.getContentIdentifier()).toString();
    }

    public byte[] asBytes() {
        try {
            return Long.toString(this.myRevision.getTimestamp()).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getContentIdentifier() {
        return this.myRevision.getContentIdentifier();
    }

    public String getName() {
        return this.myStore.getName();
    }

    public boolean isContainer() {
        return this.myStore.getType() != 1;
    }
}

