/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.team;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileHistoryProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.core.history.provider.FileHistoryProvider;

public class SemanticFileHistoryProvider
extends FileHistoryProvider
implements IAdaptable {
    private final ISemanticFileSystem sfs;
    private static final IFileHistory EMPTY_HISTORY = new FileHistory(){

        public IFileRevision[] getTargets(IFileRevision revision) {
            return new IFileRevision[0];
        }

        public IFileRevision[] getFileRevisions() {
            return new IFileRevision[0];
        }

        public IFileRevision getFileRevision(String id) {
            return null;
        }

        public IFileRevision[] getContributors(IFileRevision revision) {
            return new IFileRevision[0];
        }
    };

    public SemanticFileHistoryProvider(ISemanticFileSystem actSfs) {
        this.sfs = actSfs;
    }

    public IFileHistory getFileHistoryFor(IResource resource, int flags, IProgressMonitor monitor) {
        IFileStore store;
        try {
            store = EFS.getStore((URI)resource.getLocationURI());
        }
        catch (CoreException e) {
            this.sfs.getLog().log(e);
            return EMPTY_HISTORY;
        }
        return this.getFileHistoryFor(store, flags, monitor);
    }

    public IFileHistory getFileHistoryFor(IFileStore store, int flags, IProgressMonitor monitor) {
        block3: {
            try {
                ISemanticFileStore sstore;
                ISemanticContentProvider provider;
                ISemanticFileHistoryProvider hist;
                if (store instanceof ISemanticFileStore && (hist = (ISemanticFileHistoryProvider)(provider = (sstore = (ISemanticFileStore)store).getEffectiveContentProvider()).getAdapter(ISemanticFileHistoryProvider.class)) != null) {
                    return hist.getHistoryFor(sstore, flags, monitor);
                }
            }
            catch (CoreException e) {
                IFileSystem fs = store.getFileSystem();
                if (!(fs instanceof ISemanticFileSystem)) break block3;
                ((ISemanticFileSystem)fs).getLog().log(e);
            }
        }
        return EMPTY_HISTORY;
    }

    public IFileRevision getWorkspaceFileRevision(IResource resource) {
        block5: {
            IFileStore store;
            try {
                store = EFS.getStore((URI)resource.getLocationURI());
            }
            catch (CoreException e1) {
                this.sfs.getLog().log(e1);
                return null;
            }
            try {
                ISemanticFileStore sstore;
                ISemanticContentProvider provider;
                ISemanticFileHistoryProvider hist;
                if (store instanceof ISemanticFileStore && (hist = (ISemanticFileHistoryProvider)(provider = (sstore = (ISemanticFileStore)store).getEffectiveContentProvider()).getAdapter(ISemanticFileHistoryProvider.class)) != null) {
                    return hist.getWorkspaceFileRevision(sstore);
                }
            }
            catch (CoreException e) {
                IFileSystem fs = store.getFileSystem();
                if (!(fs instanceof ISemanticFileSystem)) break block5;
                ((ISemanticFileSystem)fs).getLog().log(e);
            }
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        IConfigurationElement[] elements;
        if (adapter.getName().equals("org.eclipse.team.ui.history.IHistoryPageSource") && (elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources.semantic.historyPageSource")) != null && elements.length > 0) {
            IConfigurationElement element = elements[0];
            try {
                Object extension = element.createExecutableExtension("class");
                return extension;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

