/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.resources.semantic.ISemanticFileStoreInternal;
import org.eclipse.core.internal.resources.semantic.SemanticResourceAdapterImpl;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticFolderAdapterImpl
extends SemanticResourceAdapterImpl
implements ISemanticFolder {
    private final IContainer container;

    SemanticFolderAdapterImpl(IContainer container, ISemanticFileSystem fileSystem) {
        super((IResource)container, fileSystem);
        this.container = container;
    }

    @Override
    public ISemanticResource getResource(String name) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        ISemanticFileStoreInternal childStore = store.getChildResource(name);
        return this.wrapChildWithResource(name, childStore);
    }

    @Override
    public ISemanticResource addResource(String name, int options, IProgressMonitor monitor) throws CoreException {
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        ISemanticFileStoreInternal childStore = store.addResourceFromRemote(name, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithResource(name, childStore);
    }

    @Override
    public ISemanticFile addFile(String name, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 1);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.addFileFromRemote(name, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFile(name);
    }

    @Override
    public ISemanticFolder addFolder(String name, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 2);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.addFolderFromRemote(name, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFolder(name);
    }

    @Override
    public ISemanticFile addFile(String name, URI uri, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 1);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.addFileFromRemoteByURI(name, uri, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFile(name);
    }

    @Override
    public ISemanticFolder addFolder(String name, URI uri, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 2);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.addFolderFromRemoteByURI(name, uri, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFolder(name);
    }

    @Override
    public ISemanticFolder addFolder(String name, String contentProviderID, Map<QualifiedName, String> properties, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 2);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.addResource(name, true, contentProviderID, properties, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFolder(name);
    }

    @Override
    public ISemanticFile addFile(String name, String contentProviderID, Map<QualifiedName, String> properties, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 2);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.addResource(name, false, contentProviderID, properties, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFile(name);
    }

    @Override
    public boolean hasResource(String name) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        return store.hasResource(name);
    }

    @Override
    public IContainer getAdaptedContainer() {
        return this.container;
    }

    @Override
    public ISemanticFile createFileRemotely(String name, InputStream source, Object context, int options, IProgressMonitor monitor) throws CoreException {
        this.validateName(name, 1);
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        store.createFileRemotely(name, source, context, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithFile(name);
    }

    @Override
    public ISemanticResource createResourceRemotely(String name, Object context, int options, IProgressMonitor monitor) throws CoreException {
        this.checkCurrentRule(SemanticResourceAdapterImpl.RuleType.REFRESH);
        ISemanticFileStoreInternal store = this.getOwnStore();
        ISemanticFileStoreInternal childStore = store.createResourceRemotely(name, context, monitor);
        this.refreshLocalIfNeeded(SemanticResourceAdapterImpl.RuleType.MODIFY, this.getRuleForType(SemanticResourceAdapterImpl.RuleType.MODIFY, (IResource)this.container), options, monitor);
        return this.wrapChildWithResource(name, childStore);
    }

    @Override
    public IStatus validateRemoteCreate(String name, Object shell) {
        try {
            ISemanticFileStoreInternal store = this.getOwnStore();
            return store.validateRemoteCreate(name, shell);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.CORE.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), e.getMessage(), (Throwable)e);
            }
            return e.getStatus();
        }
    }

    public boolean supportsMove(ISemanticFolder targetFolder, String targetName, IProgressMonitor monitor) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        ISemanticFileStore targetParent = (ISemanticFileStore)((Object)SemanticFolderAdapterImpl.getStoreForResource(targetFolder.getAdaptedResource()));
        return store.supportsMove(targetParent, targetName, monitor);
    }

    private ISemanticResource wrapChildWithResource(String name, ISemanticFileStoreInternal childStore) {
        Object resource = null;
        if (childStore != null) {
            resource = childStore.getType() == 1 ? this.container.getFile((IPath)new Path(name)) : this.container.getFolder((IPath)new Path(name));
        }
        if (resource != null) {
            ISemanticResource child = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            return child;
        }
        return null;
    }

    private ISemanticFile wrapChildWithFile(String name) {
        IFile resource = this.container.getFile((IPath)new Path(name));
        if (resource != null) {
            ISemanticFile child = (ISemanticFile)resource.getAdapter(ISemanticFile.class);
            return child;
        }
        return null;
    }

    private ISemanticFolder wrapChildWithFolder(String name) {
        IFolder resource = this.container.getFolder((IPath)new Path(name));
        if (resource != null) {
            ISemanticFolder child = (ISemanticFolder)resource.getAdapter(ISemanticFolder.class);
            return child;
        }
        return null;
    }

    private void validateName(String name, int type) throws CoreException {
        IStatus test = this.container.getWorkspace().validateName(name, type);
        if (!test.isOK()) {
            throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_RESOURCE_NAME, this.container.getFullPath(), test.getMessage());
        }
    }

    @Override
    public IResource[] findURI(URI uri, IProgressMonitor monitor) throws CoreException {
        ISemanticFileStoreInternal store = this.getOwnStore();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IPath[] paths = store.findURI(uri, monitor);
        IPath root = ((ISemanticFileStore)((Object)store)).getPath();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res;
            IPath iPath = iPathArray[n2];
            if (root.isPrefixOf(iPath) && (res = this.container.findMember(this.makeRelativeTo(root, iPath))) != null) {
                resources.add(res);
            }
            ++n2;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IPath makeRelativeTo(IPath base, IPath other) {
        String baseString = base.toString();
        String otherString = other.toString();
        if (baseString.length() == otherString.length()) {
            return Path.EMPTY;
        }
        if (base.hasTrailingSeparator()) {
            return new Path(otherString.substring(baseString.length()));
        }
        return new Path(otherString.substring(baseString.length() + 1));
    }
}

